/*
 * Decompiled with CFR 0.152.
 */
package nl.sivworks.util;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import nl.sivworks.util.CompareTool;

public class PropertyChangeHandler
extends PropertyChangeSupport {
    private final VetoableChangeSupport vetoableChangeSupport;
    private transient List<PropertyChangeListener> listeners;

    public PropertyChangeHandler(Object source) {
        super(source);
        this.vetoableChangeSupport = new VetoableChangeSupport(source);
        this.listeners = new ArrayList<PropertyChangeListener>();
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
            super.addPropertyChangeListener(listener);
            if (listener instanceof VetoableChangeListener) {
                VetoableChangeListener vcl = (VetoableChangeListener)((Object)listener);
                this.vetoableChangeSupport.addVetoableChangeListener(vcl);
            }
        }
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.remove(listener);
        super.removePropertyChangeListener(listener);
        if (listener instanceof VetoableChangeListener) {
            VetoableChangeListener vcl = (VetoableChangeListener)((Object)listener);
            this.vetoableChangeSupport.removeVetoableChangeListener(vcl);
        }
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (!CompareTool.isEqual(oldValue, newValue)) {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public synchronized void removePropertyChangeListeners() {
        for (PropertyChangeListener listener : new ArrayList<PropertyChangeListener>(this.listeners)) {
            this.removePropertyChangeListener(listener);
        }
    }

    public void fireVetoableChange(String propertyName, Object oldValue, Object newValue) throws PropertyVetoException {
        if (!CompareTool.isEqual(oldValue, newValue)) {
            this.vetoableChangeSupport.fireVetoableChange(propertyName, oldValue, newValue);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.listeners = new ArrayList<PropertyChangeListener>();
    }
}

