/*
 * Decompiled with CFR 0.152.
 */
package nl.sivworks.util;

import java.util.ArrayList;
import java.util.List;
import nl.sivworks.util.ProgressListener;

public class ProgressProducer {
    private final List<ProgressListener> listeners = new ArrayList<ProgressListener>();

    public synchronized void addProgressListener(ProgressListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("ProgressListener is null");
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public synchronized void removeProgressListener(ProgressListener listener) {
        this.listeners.remove(listener);
    }

    public synchronized void removeProgressListeners() {
        this.listeners.clear();
    }

    public synchronized List<ProgressListener> getProgressListeners() {
        return new ArrayList<ProgressListener>(this.listeners);
    }

    public void fireStart(int minimum, int maximum) {
        for (ProgressListener listener : this.getProgressListeners()) {
            listener.start(minimum, maximum);
        }
    }

    public void fireProgress(int count, Object object) {
        for (ProgressListener listener : this.getProgressListeners()) {
            listener.progress(count, object);
        }
    }

    public void fireDone(int count, Object object) {
        for (ProgressListener listener : this.getProgressListeners()) {
            listener.done(count, object);
        }
    }

    public void fireReady() {
        for (ProgressListener listener : this.getProgressListeners()) {
            listener.ready();
        }
    }

    public void fireFailed(Throwable cause) {
        for (ProgressListener listener : this.getProgressListeners()) {
            listener.failed(cause);
        }
    }
}

