/*
 * Decompiled with CFR 0.152.
 */
package nl.sivworks.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Locale;

public final class LocaleTool {
    public static final Locale DUTCH = LocaleTool.createLocale("nl");
    public static final Locale ENGLISH = Locale.US;
    public static final Locale FRENCH = Locale.FRENCH;
    public static final Locale GERMAN = Locale.GERMAN;
    public static final Locale ITALIAN = Locale.ITALIAN;
    public static final Locale NORWEGIAN = LocaleTool.createLocale("no");
    public static final Locale PORTUGESE = LocaleTool.createLocale("pt");
    public static final Locale SPANISH = LocaleTool.createLocale("es");
    private static final Locale[] PROGRAM_LOCALES;

    private LocaleTool() {
    }

    public static Locale[] getProgramLocales() {
        return PROGRAM_LOCALES;
    }

    public static Locale getDefaultProgramLocale() {
        Locale locale = Locale.getDefault();
        for (Locale l : PROGRAM_LOCALES) {
            if (!locale.getLanguage().equals(l.getLanguage())) continue;
            return l;
        }
        return ENGLISH;
    }

    public static Locale createLocale(String language) {
        String[] parts = language.split("_");
        if (parts.length == 1) {
            return Locale.of(parts[0]);
        }
        if (parts.length == 2) {
            return Locale.of(parts[0], parts[1]);
        }
        if (parts.length == 3) {
            return Locale.of(parts[0], parts[1], parts[2]);
        }
        return null;
    }

    static {
        ArrayList<Locale> locales = new ArrayList<Locale>();
        locales.add(DUTCH);
        locales.add(ENGLISH);
        locales.add(GERMAN);
        locales.sort(new LocaleComparator());
        PROGRAM_LOCALES = locales.toArray(new Locale[0]);
    }

    public static class LocaleComparator
    implements Comparator<Locale> {
        @Override
        public int compare(Locale a, Locale b) {
            return a.getDisplayName(a).toUpperCase().compareTo(b.getDisplayName(b).toUpperCase());
        }
    }
}

