/*
 * Decompiled with CFR 0.152.
 */
package nl.sivworks.util;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import nl.sivworks.io.FileTool;
import nl.sivworks.text.DefaultTextHolder;
import nl.sivworks.text.TextHolders;
import nl.sivworks.util.ApplicationException;

public final class ImageTool {
    public static BufferedImage loadImage(File file) throws ApplicationException, IOException {
        ImageIO.setUseCache(false);
        try {
            return ImageIO.read(file);
        }
        catch (IllegalArgumentException exc) {
            if (exc.getMessage().equals("Numbers of source Raster bands and source color space components do not match")) {
                return ImageTool.readImageLenient(file);
            }
            throw new ApplicationException(TextHolders.get("Msg|UnexpectedError"), (Throwable)exc);
        }
    }

    private static BufferedImage readImageLenient(File file) throws IOException {
        return ImageTool.readImage(new FileInputStream(file));
    }

    private static BufferedImage readImage(InputStream stream) throws IOException {
        Iterator<ImageReader> imageReaders = ImageIO.getImageReadersBySuffix("jpg");
        ImageReader imageReader = imageReaders.next();
        ImageInputStream iis = ImageIO.createImageInputStream(stream);
        imageReader.setInput(iis, true, true);
        Raster raster = imageReader.readRaster(0, null);
        int w = raster.getWidth();
        int h = raster.getHeight();
        BufferedImage result = new BufferedImage(w, h, 1);
        int[] rgb = new int[3];
        int[] pixel = new int[3];
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                raster.getPixel(x, y, pixel);
                int Y = pixel[0];
                int CR = pixel[1];
                int CB = pixel[2];
                ImageTool.toRGB(Y, CB, CR, rgb);
                int r = rgb[0];
                int g = rgb[1];
                int b = rgb[2];
                int bgr = (b & 0xFF) << 16 | (g & 0xFF) << 8 | r & 0xFF;
                result.setRGB(x, y, bgr);
            }
        }
        return result;
    }

    private static void toRGB(int y, int cb, int cr, int[] rgb) {
        float Y = (float)y / 255.0f;
        float Cb = (float)(cb - 128) / 255.0f;
        float Cr = (float)(cr - 128) / 255.0f;
        float R = Y + 1.4f * Cr;
        float G = Y - 0.343f * Cb - 0.711f * Cr;
        float B = Y + 1.765f * Cb;
        R = Math.min(1.0f, Math.max(0.0f, R));
        G = Math.min(1.0f, Math.max(0.0f, G));
        B = Math.min(1.0f, Math.max(0.0f, B));
        int r = (int)(R * 255.0f);
        int g = (int)(G * 255.0f);
        int b = (int)(B * 255.0f);
        rgb[0] = r;
        rgb[1] = g;
        rgb[2] = b;
    }

    public static void saveImage(Image image, String format, File file) throws IOException {
        if (image instanceof BufferedImage) {
            ImageTool.storeImage((BufferedImage)image, format, file);
            return;
        }
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        BufferedImage outputImage = new BufferedImage(width, height, 1);
        Graphics2D graphics = outputImage.createGraphics();
        graphics.drawImage(image, 0, 0, null);
        graphics.dispose();
        ImageTool.storeImage(outputImage, format, file);
    }

    public static Dimension createScaledImageFile(File imageFile, File outputFile, Dimension dimension) throws ApplicationException, IOException {
        String format = ImageTool.getImageFormat(imageFile);
        BufferedImage image = ImageTool.loadImage(imageFile);
        BufferedImage scaledImage = ImageTool.createScaledImage(image, dimension);
        ImageTool.storeImage(scaledImage, format, outputFile);
        return new Dimension(scaledImage.getWidth(null), scaledImage.getHeight(null));
    }

    public static Dimension createScaledImageFile(File imageFile, File outputFile, ScaleType type, int size) throws ApplicationException, IOException {
        String format = ImageTool.getImageFormat(imageFile);
        BufferedImage image = ImageTool.loadImage(imageFile);
        BufferedImage scaledImage = ImageTool.createScaledImage(image, type, size);
        ImageTool.storeImage(scaledImage, format, outputFile);
        return new Dimension(scaledImage.getWidth(null), scaledImage.getHeight(null));
    }

    public static BufferedImage createScaledImage(File file, Dimension dimension) throws ApplicationException, IOException {
        BufferedImage image = ImageTool.loadImage(file);
        if (image == null) {
            return null;
        }
        return ImageTool.createScaledImage(image, dimension);
    }

    public static BufferedImage createScaledImage(BufferedImage image, Dimension dimension) {
        int size;
        ScaleType type;
        if ((double)image.getWidth() / dimension.getWidth() > (double)image.getHeight() / dimension.getHeight()) {
            type = ScaleType.WIDTH;
            size = (int)dimension.getWidth();
        } else {
            type = ScaleType.HEIGHT;
            size = (int)dimension.getHeight();
        }
        return ImageTool.createScaledImage(image, type, size);
    }

    public static BufferedImage createScaledImage(BufferedImage image, ScaleType type, int size) {
        double ratio = type == ScaleType.WIDTH ? (double)size / (double)image.getWidth() : (double)size / (double)image.getHeight();
        while (ratio < 0.5) {
            image = ImageTool.scale(image, 0.5);
            if (type == ScaleType.WIDTH) {
                ratio = (double)size / (double)image.getWidth();
                continue;
            }
            ratio = (double)size / (double)image.getHeight();
        }
        return ImageTool.scale(image, ratio);
    }

    public static boolean isImageFile(File file) {
        try {
            ImageTool.getImageFormat(file);
            return true;
        }
        catch (Exception exc) {
            return false;
        }
    }

    public static String getImageFormat(File file) throws ApplicationException {
        String extension = FileTool.getExtension(file);
        if (extension != null) {
            String format = extension.toLowerCase();
            if (format.equals("jpg") || format.equals("png") || format.equals("gif") || format.equals("bmp")) {
                return format;
            }
            if (format.equals("jpeg")) {
                return "jpg";
            }
        }
        throw new ApplicationException(new DefaultTextHolder("Msg|InvalidImageFileExtension", extension));
    }

    public static boolean isGrayScale(File file) {
        try {
            BufferedImage image = ImageIO.read(file);
            if (image.getRaster().getNumDataElements() == 1) {
                return true;
            }
            int width = image.getWidth();
            int height = image.getHeight();
            int[] pixels = image.getRGB(0, 0, width, height, null, 0, width);
            for (int i = 0; i < pixels.length; ++i) {
                int rgb = pixels[i];
                int r = (0xFF0000 & rgb) >> 16;
                int g = (0xFF00 & rgb) >> 8;
                int b = 0xFF & rgb;
                if (r == g && r == b) continue;
                return false;
            }
            return true;
        }
        catch (Exception exc) {
            return false;
        }
    }

    private static BufferedImage scale(BufferedImage image, double ratio) {
        int width = (int)((double)image.getWidth() * ratio);
        int height = (int)((double)image.getHeight() * ratio);
        BufferedImage scaledImage = new BufferedImage(width, height, 1);
        Graphics2D graphics2D = scaledImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(image, 0, 0, width, height, null);
        graphics2D.dispose();
        return scaledImage;
    }

    private static void storeImage(BufferedImage image, String format, File file) throws IOException {
        if (!file.getParentFile().exists()) {
            Files.createDirectories(file.getParentFile().toPath(), new FileAttribute[0]);
        }
        ImageIO.write((RenderedImage)image, format, file);
    }

    public static enum ScaleType {
        WIDTH,
        HEIGHT;

    }
}

