/*
 * Decompiled with CFR 0.152.
 */
package nl.sivworks.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileTime;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import nl.sivworks.io.FileTool;
import nl.sivworks.text.Text;

public class ZipFileWriter
implements AutoCloseable {
    private static final char SLASH = '/';
    private static final char BACKSLASH = '\\';
    private final File zipFile;
    private ZipOutputStream zipStream;

    public ZipFileWriter(File zipFile) {
        this.zipFile = zipFile;
    }

    @Override
    public void close() {
        try {
            if (this.zipStream != null) {
                this.zipStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.zipStream = null;
    }

    public void add(File path, File file) throws IOException {
        if (path != null) {
            this.add(path, FileTool.getRelativePath(path, file));
        } else {
            this.add(null, file.getPath());
        }
    }

    public void add(File path, String fileName) throws IOException {
        int index;
        File file;
        if (path == null) {
            file = new File(fileName);
            index = -1;
        } else {
            file = new File(path, fileName);
            index = path.getPath().length() + 1;
        }
        if (!file.exists()) {
            throw new FileNotFoundException(Text.get("Msg|FileNotFound", file));
        }
        for (File f : FileTool.getFilesAndDirectories(file)) {
            Object entryName = f.getPath();
            if (index != -1) {
                entryName = ((String)entryName).substring(index);
            }
            if (f.isDirectory()) {
                entryName = (String)entryName + File.separator;
            }
            this.addEntry(f, (String)entryName);
        }
    }

    public void addEntry(File file, String entryName) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException(Text.get("Msg|FileNotFound", file));
        }
        ZipEntry zipEntry = new ZipEntry(entryName.replace('\\', '/'));
        zipEntry.setLastModifiedTime(FileTime.fromMillis(file.lastModified()));
        if (file.isDirectory() || file.length() == 0L) {
            zipEntry.setMethod(0);
            zipEntry.setSize(0L);
            zipEntry.setCrc(0L);
        }
        byte[] data = file.isDirectory() || file.length() == 0L ? new byte[]{} : Files.readAllBytes(file.toPath());
        this.addEntry(zipEntry, data);
    }

    public void addEntry(ZipEntry entry, byte[] data) throws IOException {
        if (this.zipStream == null) {
            this.zipStream = new ZipOutputStream(new FileOutputStream(this.zipFile));
        }
        this.zipStream.putNextEntry(entry);
        this.zipStream.write(data, 0, data.length);
        this.zipStream.closeEntry();
    }
}

