/*
 * Decompiled with CFR 0.152.
 */
package nl.sivworks.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import nl.sivworks.io.FileTool;
import nl.sivworks.text.DefaultTextHolder;
import nl.sivworks.util.ApplicationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockHandler {
    private static final Logger logger = LoggerFactory.getLogger(LockHandler.class);
    private final String name;
    private final File lockFile;
    private RandomAccessFile stream;
    private FileChannel fileChannel;
    private FileLock fileLock;

    public LockHandler(String name, File lockFile) {
        this.name = name;
        this.lockFile = lockFile;
        if (logger.isDebugEnabled()) {
            logger.debug("LockHandler <init> " + name + " -> lock file " + String.valueOf(lockFile));
        }
    }

    public File getLockFile() {
        return this.lockFile;
    }

    public synchronized boolean acquireLock() throws ApplicationException {
        if (logger.isDebugEnabled()) {
            logger.debug("Try to acquire lock for " + this.name);
        }
        if (this.hasLock()) {
            return true;
        }
        FileTool.createDirectory(this.lockFile.getParentFile());
        try {
            this.stream = new RandomAccessFile(this.lockFile, "rw");
            this.fileChannel = this.stream.getChannel();
            this.fileLock = this.fileChannel.tryLock();
            if (this.fileLock == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Failed to acquire lock for " + this.name);
                }
                this.reset();
                return false;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Successfully acquired lock for " + this.name);
            }
            this.lockFile.setReadable(true);
            this.lockFile.setWritable(true);
        }
        catch (Exception exc) {
            this.reset();
            throw new ApplicationException(new DefaultTextHolder("Msg|FailedToCreateLockFile", this.lockFile), (Throwable)exc);
        }
        return true;
    }

    public synchronized void releaseLock() throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("Release lock for " + this.name);
        }
        if (!this.hasLock()) {
            throw new IllegalStateException("Lock is null");
        }
        this.reset();
        Files.delete(this.lockFile.toPath());
    }

    public boolean hasLock() {
        return this.fileLock != null;
    }

    private void reset() {
        try {
            if (this.fileChannel != null) {
                this.fileChannel.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.stream != null) {
                this.stream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.stream = null;
        this.fileChannel = null;
        this.fileLock = null;
    }
}

