/*
 * Decompiled with CFR 0.152.
 */
package nl.sivworks.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import nl.sivworks.io.BytesInputStream;

public class BytesOutputStream
extends OutputStream {
    private static final int DEFAULT_INITIAL_BUFFER_SIZE = 8192;
    private byte[] buffer;
    private int index;
    private int capacity;
    private boolean closed;
    private boolean shared;

    public BytesOutputStream() {
        this(8192);
    }

    public BytesOutputStream(int initialBufferSize) {
        this.capacity = initialBufferSize;
        this.buffer = new byte[this.capacity];
    }

    @Override
    public void write(int datum) throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        if (this.index >= this.capacity) {
            this.capacity = this.capacity * 2 + 1;
            byte[] tmp = new byte[this.capacity];
            System.arraycopy(this.buffer, 0, tmp, 0, this.index);
            this.buffer = tmp;
            this.shared = false;
        }
        this.buffer[this.index++] = (byte)datum;
    }

    @Override
    public void write(byte[] data, int offset, int length) throws IOException {
        if (data == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || offset + length > data.length || length < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        if (this.index + length > this.capacity) {
            this.capacity = this.capacity * 2 + length;
            byte[] tmp = new byte[this.capacity];
            System.arraycopy(this.buffer, 0, tmp, 0, this.index);
            this.buffer = tmp;
            this.shared = false;
        }
        System.arraycopy(data, offset, this.buffer, this.index, length);
        this.index += length;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    public byte[] toByteArray() {
        byte[] result = new byte[this.index];
        System.arraycopy(this.buffer, 0, result, 0, this.index);
        return result;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.buffer, 0, this.index);
    }

    public InputStream toInputStream() {
        this.shared = true;
        return new BytesInputStream(this.buffer, 0, this.index);
    }

    public void reset() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        if (this.shared) {
            this.buffer = new byte[this.capacity];
            this.shared = false;
        }
        this.index = 0;
    }
}

