/*
 * Decompiled with CFR 0.152.
 */
package nl.sivworks.installer.runtime;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import nl.sivworks.installer.data.CopyAction;
import nl.sivworks.installer.data.DirectoryAction;
import nl.sivworks.installer.data.FileAction;
import nl.sivworks.installer.data.InstallMap;
import nl.sivworks.installer.data.Shortcut;
import nl.sivworks.installer.runtime.Installer;
import nl.sivworks.installer.util.InstallerException;
import nl.sivworks.installer.util.InstallerSystem;
import nl.sivworks.installer.util.InstallerTool;
import nl.sivworks.io.FileTool;
import nl.sivworks.io.ZipFileReader;
import nl.sivworks.io.ZipFileUpdater;
import nl.sivworks.text.Text;
import nl.sivworks.util.ApplicationException;
import nl.sivworks.util.Environment;
import nl.sivworks.util.ProductEnvironment;
import nl.sivworks.util.ProgressListener;

public final class InstallWorker
extends SwingWorker<Object, ProgressInfo> {
    private final Installer installer;
    private final ProgressListener progressListener;

    public InstallWorker(Installer installer, ProgressListener progressListener) {
        this.installer = installer;
        this.progressListener = progressListener;
    }

    public void install() {
        this.progressListener.start(0, 5);
        this.execute();
    }

    @Override
    protected Object doInBackground() throws InstallerException {
        InstallMap map = (InstallMap)this.installer.getConfiguration().get("Install Map");
        File home = (File)this.installer.getConfiguration().get("Home Directory");
        ArrayList<File> installedFiles = new ArrayList<File>();
        this.publish(0, Text.get("Msg|PreparingInstallation", new Object[0]) + "...");
        InstallWorker.prepareHome(home, installedFiles);
        this.publish(1, Text.get("Msg|Installing", map.getPackageName()) + "...");
        this.installPackage(home, map, installedFiles);
        this.publish(2, null);
        this.handleFilePermissions(installedFiles);
        this.publish(3, null);
        this.handleSpecialActions(home, map, installedFiles);
        this.handleDpi(home, installedFiles);
        this.publish(4, null);
        this.handleAdministration(home, map, installedFiles);
        this.publish(5, null);
        this.handleShortcuts(home, map, installedFiles);
        this.publish(6, null);
        this.handleUninstaller(home, map, installedFiles);
        return null;
    }

    @Override
    protected void process(List<ProgressInfo> infoList) {
        for (ProgressInfo info : infoList) {
            this.progressListener.progress(info.getCount(), info.getText());
        }
    }

    @Override
    protected void done() {
        try {
            this.get();
            this.progressListener.ready();
        }
        catch (ExecutionException exc) {
            this.installer.logError(exc.getCause());
            this.progressListener.failed(InstallWorker.getInstallerException(exc.getCause()));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void publish(int count, String text) {
        this.publish(new ProgressInfo(count, text));
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static boolean isHighDpi(File home) {
        String scale = System.getenv("GDK_SCALE");
        return scale != null && scale.equals("2");
    }

    private static void prepareHome(File home, List<File> installedFiles) throws InstallerException {
        if (home.isDirectory()) {
            try {
                FileTool.cleanUpDirectory(home);
                installedFiles.add(home);
                return;
            }
            catch (ApplicationException exc) {
                throw new InstallerException(exc.getMessage(), exc);
            }
        }
        installedFiles.addAll(InstallerTool.createDirectories(home));
    }

    private void installPackage(File home, InstallMap map, List<File> installedFiles) throws InstallerException {
        File manifestFile = new File(home, "META-INF/MANIFEST.MF");
        try {
            InputStream stream = this.getClass().getResourceAsStream("/" + map.getPackageName() + ".jar");
            ZipFileReader reader = new ZipFileReader(stream);
            reader.extract(home);
            for (File file : reader.getExtractedFiles()) {
                if (file.getPath().equalsIgnoreCase(manifestFile.getPath())) {
                    file.delete();
                    file.getParentFile().delete();
                    continue;
                }
                if (file.getPath().equalsIgnoreCase(manifestFile.getParentFile().getPath())) continue;
                installedFiles.add(file);
            }
        }
        catch (Exception exc) {
            Object text = Text.get("Msg|ExtractProblem", map.getPackageName());
            if (FileTool.isCausedByAccessDenied(exc)) {
                text = (String)text + " (" + Text.get("Msg|AccessDenied", new Object[0]) + ")";
            }
            throw new InstallerException((String)text, exc);
        }
    }

    private void handleFilePermissions(List<File> files) {
        if (Environment.isLinux() || Environment.isMac()) {
            this.publish(0, Text.get("Msg|SettingPermissions", new Object[0]) + "...");
            for (File file : files) {
                file.setReadable(true);
                file.setWritable(true, true);
                file.setExecutable(file.isDirectory());
            }
        }
    }

    private void handleSpecialActions(File home, InstallMap map, List<File> installedFiles) {
        for (CopyAction copyAction : map.getCopyActions()) {
            File path = home;
            if (!copyAction.getDestination().equals(".")) {
                path = new File(home, copyAction.getDestination());
                path.mkdirs();
                String mode = copyAction.getPermissions();
                if (mode != null && mode.length() > 0) {
                    InstallerTool.setLinuxFilePermissions(path, mode);
                }
            }
            for (FileAction fileAction : copyAction.getFileActions()) {
                this.performFileAction(fileAction, path, installedFiles);
            }
            for (DirectoryAction directoryAction : copyAction.getDirectoryActions()) {
                this.performDirectoryAction(directoryAction, path, installedFiles);
            }
        }
        if (Environment.isMac()) {
            File macDirectory = new File(home, "mac");
            List<File> list = FileTool.getFilesAndDirectories(macDirectory);
            File defaultHome = new File(InstallerSystem.getDefaultRoot(), map.getBaseDirectory());
            if (home.equals(defaultHome)) {
                for (File file : FileTool.listFiles(macDirectory)) {
                    File applet = new File(file, "Contents/MacOS/applet");
                    if (applet.exists()) {
                        applet.setExecutable(true, false);
                    }
                    File target = new File("/Applications", file.getName());
                    try {
                        if (target.exists()) {
                            FileTool.removeDirectory(target);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    file.renameTo(target);
                    installedFiles.addAll(FileTool.getFilesAndDirectories(target));
                }
            }
            try {
                FileTool.removeDirectory(macDirectory);
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (File file : list) {
                if (file.exists()) continue;
                installedFiles.remove(file);
            }
        }
    }

    private void performFileAction(FileAction fileAction, File path, List<File> installedFiles) {
        File file = new File(path, new File(fileAction.getName()).getName());
        try {
            String mode;
            if (!fileAction.belongsOnOperatingSystem()) {
                if (file.delete()) {
                    installedFiles.remove(file);
                }
                return;
            }
            if (fileAction.isConvert()) {
                InstallerTool.convertFileFormat(file);
            }
            if ((mode = fileAction.getPermissions()) != null && mode.length() > 0) {
                InstallerTool.setLinuxFilePermissions(file, mode);
            }
        }
        catch (InstallerException exc) {
            this.installer.logError(exc);
        }
    }

    private void performDirectoryAction(DirectoryAction directoryAction, File path, List<File> installedFiles) {
        File directory = new File(path, new File(directoryAction.getName()).getName());
        try {
            String mode;
            if (!directoryAction.belongsOnOperatingSystem()) {
                try {
                    List<File> list = FileTool.getFilesAndDirectories(directory);
                    FileTool.removeDirectory(directory);
                    if (!directory.exists()) {
                        installedFiles.removeAll(list);
                    }
                }
                catch (Exception list) {
                    // empty catch block
                }
                return;
            }
            if (directoryAction.isConvert()) {
                for (File file : FileTool.getFiles(directory)) {
                    InstallerTool.convertFileFormat(file);
                }
            }
            if ((mode = directoryAction.getPermissions()) != null && mode.length() > 0) {
                InstallerTool.setLinuxFilePermissions(directory, mode);
            }
        }
        catch (InstallerException exc) {
            this.installer.logError(exc);
        }
    }

    private void handleDpi(File home, List<File> installedFiles) {
        if (!Environment.isLinux()) {
            return;
        }
        String scale = System.getenv("GDK_SCALE");
        boolean highDpi = scale != null && scale.equals("2");
        File options = new File(home, "options");
        if (options.mkdir()) {
            installedFiles.add(options);
            InstallerTool.setLinuxFilePermissions(options, "777");
            File normal = new File(options, "Normal-DPI");
            File high = new File(options, "High-DPI");
            File dpi = highDpi ? high : normal;
            try {
                Files.writeString(dpi.toPath(), (CharSequence)"DPI", new OpenOption[0]);
                InstallerTool.setLinuxFilePermissions(dpi, "666");
                installedFiles.add(normal);
                installedFiles.add(high);
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
    }

    private void handleAdministration(File home, InstallMap map, List<File> installedFiles) {
        File file = ProductEnvironment.getRegistryFile(home);
        try {
            Files.writeString(file.toPath(), (CharSequence)map.getBaseDirectory(), new OpenOption[0]);
            installedFiles.add(file);
        }
        catch (Exception exc) {
            this.installer.logError(new InstallerException(Text.get("Msg|FailedToCreateRegistry", file), exc));
        }
    }

    private void handleShortcuts(File home, InstallMap map, List<File> installedFiles) {
        List<Shortcut> shortcuts = map.getShortcuts(Environment.getOsGroup());
        if (shortcuts.isEmpty()) {
            return;
        }
        this.publish(0, Text.get("Msg|CreatingDesktopShortcut", new Object[0]) + "...");
        try {
            installedFiles.addAll(InstallerSystem.addShortcuts(home, shortcuts));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void handleUninstaller(File home, InstallMap map, List<File> installedFiles) throws InstallerException {
        File uninstallerFile = new File(home, InstallerSystem.getUninstallerName(Environment.getOsGroup()));
        File dataFile = new File(home, InstallerSystem.getUninstallerDataFileName());
        installedFiles.add(uninstallerFile);
        if (Environment.isWindows()) {
            installedFiles.add(dataFile);
        }
        HashMap<String, Object> uninstallData = new HashMap<String, Object>();
        uninstallData.put("Install Map", map);
        uninstallData.put("Installed Files", installedFiles);
        uninstallData.put("Time", System.currentTimeMillis() + 120000L);
        try {
            ObjectOutputStream output = new ObjectOutputStream(new FileOutputStream(dataFile));
            output.writeObject(uninstallData);
            output.close();
            if (Environment.isWindows()) {
                InputStream source = this.getClass().getResourceAsStream("/" + uninstallerFile.getName());
                FileOutputStream destination = new FileOutputStream(uninstallerFile);
                FileTool.copy(source, destination);
            } else {
                File jarFile = new File(home, InstallerSystem.getUninstallerJarName());
                InputStream source = this.getClass().getResourceAsStream("/" + jarFile.getName());
                FileOutputStream destination = new FileOutputStream(jarFile);
                FileTool.copy(source, destination);
                File templateFile = new File(home, InstallerSystem.getUninstallerTemplateName());
                source = this.getClass().getResourceAsStream("/" + templateFile.getName());
                destination = new FileOutputStream(templateFile);
                FileTool.copy(source, destination);
                ZipFileUpdater updater = new ZipFileUpdater(jarFile);
                updater.add(dataFile.getParentFile(), dataFile.getName());
                updater.close();
                String text = InstallerTool.encodeToString(jarFile);
                String template = Files.readString(templateFile.toPath());
                Files.writeString(uninstallerFile.toPath(), (CharSequence)(template + text), new OpenOption[0]);
                jarFile.delete();
                dataFile.delete();
                templateFile.delete();
            }
        }
        catch (Exception exc) {
            throw new InstallerException(Text.get("Msg|UninstallFileError", new Object[0]), exc);
        }
    }

    private static InstallerException getInstallerException(Throwable cause) {
        if (cause instanceof InstallerException) {
            return (InstallerException)cause;
        }
        return new InstallerException(Text.get("Msg|UnexpectedError", new Object[0]), cause);
    }

    public static class ProgressInfo {
        private final int count;
        private final String text;

        ProgressInfo(int count, String text) {
            this.count = count;
            this.text = text;
        }

        public int getCount() {
            return this.count;
        }

        public String getText() {
            return this.text;
        }
    }
}

