/*
 * Decompiled with CFR 0.152.
 */
package nl.sivworks.installer.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.sivworks.installer.data.CopyAction;
import nl.sivworks.installer.data.PreInstallCheck;
import nl.sivworks.installer.data.Program;
import nl.sivworks.installer.data.ProgramDataTemplateAction;
import nl.sivworks.installer.data.Shortcut;
import nl.sivworks.util.Environment;

public class InstallMap
implements Serializable {
    private String packageName;
    private String version;
    private String copyright;
    private String baseDirectory;
    private String javaVersion;
    private PreInstallCheck preInstallCheck;
    private ProgramDataTemplateAction templateAction;
    private final Map<String, String> packageDependencies = new HashMap<String, String>();
    private final List<Environment.OsGroup> platforms = new ArrayList<Environment.OsGroup>();
    private final List<CopyAction> copyActions = new ArrayList<CopyAction>();
    private final List<Shortcut> shortcuts = new ArrayList<Shortcut>();
    private final List<Program> programs = new ArrayList<Program>();

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    public String getBaseDirectory() {
        return this.baseDirectory;
    }

    public void setBaseDirectory(String baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public void setJavaVersion(String javaVersion) {
        this.javaVersion = javaVersion;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public PreInstallCheck getPreInstallCheck() {
        return this.preInstallCheck;
    }

    public void setPreInstallCheck(PreInstallCheck preInstallCheck) {
        this.preInstallCheck = preInstallCheck;
    }

    public void addPackageDependency(String name, String version) {
        this.packageDependencies.put(name, version);
    }

    public Map<String, String> getPackageDependencies() {
        return this.packageDependencies;
    }

    public void addPlatform(Environment.OsGroup platform) {
        if (platform != null && !this.platforms.contains((Object)platform)) {
            this.platforms.add(platform);
        }
    }

    public List<Environment.OsGroup> getPlatforms() {
        return this.platforms;
    }

    public void setProgramDataTemplateAction(ProgramDataTemplateAction action) {
        this.templateAction = action;
    }

    public ProgramDataTemplateAction getProgramDataTemplateAction() {
        return this.templateAction;
    }

    public void addCopyAction(CopyAction action) {
        this.copyActions.add(action);
    }

    public List<CopyAction> getCopyActions() {
        return this.copyActions;
    }

    public void addShortcut(Shortcut shortcut) {
        this.shortcuts.add(shortcut);
    }

    public List<Shortcut> getShortcuts(Environment.OsGroup operatingSystem) {
        ArrayList<Shortcut> list = new ArrayList<Shortcut>();
        for (Shortcut shortcut : this.shortcuts) {
            if (!shortcut.getOperatingSystem().equalsIgnoreCase(operatingSystem.name())) continue;
            list.add(shortcut);
        }
        return list;
    }

    public boolean hasShortcuts() {
        return !this.shortcuts.isEmpty();
    }

    public void addProgram(Program program) {
        this.programs.add(program);
    }

    public Program getProgram(Environment.OsGroup operatingSystem) {
        for (Program program : this.programs) {
            if (!program.getOperatingSystem().equalsIgnoreCase(operatingSystem.name())) continue;
            return program;
        }
        return null;
    }
}

