/*
 * Decompiled with CFR 0.152.
 */
package nl.sivworks.util;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import nl.sivworks.io.BytesInputStream;

public class XmlEntityCache {
    public static final int MAX_CHUNK = 20480;
    private final Map<String, SoftReference<byte[]>> entities = new HashMap<String, SoftReference<byte[]>>();
    private final byte[] buf = new byte[20480];

    public InputStream getEntity(String location) {
        byte[] entity = null;
        SoftReference<byte[]> reference = this.entities.get(location);
        if (reference != null) {
            entity = reference.get();
        }
        if (entity == null) {
            return this.cacheEntity(location);
        }
        return new BytesInputStream(entity);
    }

    public InputStream getEntity(URL location) {
        byte[] entity = null;
        SoftReference<byte[]> reference = this.entities.get(location.toExternalForm());
        if (reference != null) {
            entity = reference.get();
        }
        if (entity == null) {
            return this.cacheEntity(location);
        }
        return new BytesInputStream(entity);
    }

    private InputStream cacheEntity(String location) {
        try {
            return this.cacheEntity(new URI(location).toURL());
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InputStream cacheEntity(URL location) {
        try (BufferedInputStream stream = new BufferedInputStream(location.openStream());){
            int count;
            int i = 0;
            for (count = 0; count < this.buf.length && (i = stream.read(this.buf, count, this.buf.length - count)) >= 0; count += i) {
            }
            byte[] entity = new byte[count];
            System.arraycopy(this.buf, 0, entity, 0, count);
            if (count != this.buf.length) {
                this.entities.put(location.toExternalForm(), new SoftReference<byte[]>(entity));
                BytesInputStream bytesInputStream = new BytesInputStream(entity);
                return bytesInputStream;
            }
            SequenceInputStream sequenceInputStream = new SequenceInputStream(new BytesInputStream(entity), stream);
            return sequenceInputStream;
        }
        catch (Exception exc) {
            return null;
        }
    }
}

