/*
 * Decompiled with CFR 0.152.
 */
package nl.sivworks.text;

import java.util.Map;
import java.util.TreeMap;
import nl.sivworks.text.Text;
import nl.sivworks.text.TextHolder;

public final class TextHolders {
    private static final Map<String, TextHolder> map = new TreeMap<String, TextHolder>();

    private TextHolders() {
    }

    public static TextHolder get(String key) {
        TextHolder textHolder = map.get(key);
        if (textHolder == null) {
            textHolder = new KeyTextHolder(key);
            map.put(key, textHolder);
        }
        return textHolder;
    }

    private static class KeyTextHolder
    implements TextHolder {
        private final String key;

        KeyTextHolder(String key) {
            this.key = key;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof KeyTextHolder)) {
                return false;
            }
            KeyTextHolder holder = (KeyTextHolder)object;
            return this.key.equals(holder.key);
        }

        public String toString() {
            return Text.get(this.key, new Object[0]);
        }
    }
}

