/*
 * Decompiled with CFR 0.152.
 */
package nl.sivworks.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import nl.sivworks.text.Text;

public class ZipFileReader {
    private static final int BUFFER_SIZE = 8192;
    private static final char SLASH = '/';
    private static final char BACKSLASH = '\\';
    private File zipFile;
    private final List<File> extractedFiles;
    private InputStream inStream;

    public ZipFileReader(InputStream inStream) {
        this.inStream = inStream;
        this.extractedFiles = new ArrayList<File>();
    }

    public ZipFileReader(File file) {
        this.zipFile = file;
        this.extractedFiles = new ArrayList<File>();
    }

    public void extract() throws IOException {
        this.extract(null, null);
    }

    public void extract(File directory) throws IOException {
        this.extract(directory, null);
    }

    public boolean extract(String fileName) throws IOException {
        return this.extract(null, fileName);
    }

    public boolean extract(File directory, String fileName) throws IOException {
        if (fileName != null) {
            return this.extractZip(directory, fileName.replace('\\', '/'));
        }
        return this.extractZip(directory, null);
    }

    public List<File> getExtractedFiles() {
        return this.extractedFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean extractZip(File storageDirectory, String fileName) throws IOException {
        if (storageDirectory != null && !storageDirectory.isDirectory()) {
            throw new FileNotFoundException(Text.get("Msg|FileNotFound", storageDirectory));
        }
        boolean found = false;
        if (fileName == null) {
            found = true;
        }
        ZipInputStream zipStream = null;
        try {
            ZipEntry zipEntry;
            zipStream = this.zipFile == null ? new ZipInputStream(this.inStream) : new ZipInputStream(new FileInputStream(this.zipFile));
            while ((zipEntry = zipStream.getNextEntry()) != null) {
                String entryName = zipEntry.getName();
                if (fileName != null) {
                    if (!fileName.equalsIgnoreCase(entryName)) continue;
                    found = true;
                }
                File entryFile = storageDirectory == null ? new File(entryName) : new File(storageDirectory, entryName);
                File directory = new File(entryFile.getPath());
                if (!zipEntry.isDirectory()) {
                    directory = directory.getParentFile();
                }
                if (directory != null && !directory.isDirectory()) {
                    Files.createDirectories(directory.toPath(), new FileAttribute[0]);
                }
                if (!zipEntry.isDirectory()) {
                    int bytesRead;
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(entryFile));
                    byte[] buffer = new byte[8192];
                    while ((bytesRead = zipStream.read(buffer, 0, 8192)) != -1) {
                        out.write(buffer, 0, bytesRead);
                    }
                    out.close();
                }
                this.extractedFiles.add(entryFile);
                if (fileName == null || !found) continue;
                break;
            }
        }
        finally {
            try {
                if (zipStream != null) {
                    zipStream.closeEntry();
                }
            }
            catch (Exception exception) {}
            try {
                if (zipStream != null) {
                    zipStream.close();
                }
            }
            catch (Exception exception) {}
        }
        return found;
    }
}

