/*
 * Decompiled with CFR 0.152.
 */
package nl.sivworks.installer.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import nl.sivworks.installer.util.InstallerException;
import nl.sivworks.util.StringTool;

public final class Logger {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final File logFile;

    public Logger(File logFile) {
        this.logFile = logFile;
        File directory = logFile.getParentFile();
        if (!directory.exists()) {
            directory.mkdirs();
        }
    }

    public File getLogFile() {
        return this.logFile;
    }

    public void logStart() {
        this.log("\n---------- " + DATE_FORMAT.format(new Date()) + " ----------");
    }

    public void logMessage(Throwable exception) {
        if (exception instanceof InstallerException && exception.getCause() == null) {
            this.logMessage(exception.getMessage());
        } else {
            exception.printStackTrace();
            this.log(exception);
        }
    }

    public void logMessage(String message) {
        System.out.println(message);
        this.log(message);
    }

    public void log(Object message) {
        try (PrintWriter writer = new PrintWriter((Writer)new BufferedWriter(new FileWriter(this.logFile.getPath(), true)), true);){
            if (message instanceof Throwable) {
                Throwable throwable = (Throwable)message;
                throwable.printStackTrace(writer);
            } else if (message instanceof String) {
                String text = (String)message;
                for (String line : StringTool.getTokens(text, '\n')) {
                    writer.println(line);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

