/*
 * Decompiled with CFR 0.152.
 */
package nl.sivworks.installer.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.UserPrincipal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.jimmc.jshortcut.JShellLink;
import nl.sivworks.installer.InstallerConstants;
import nl.sivworks.installer.data.Shortcut;
import nl.sivworks.installer.util.InstallerException;
import nl.sivworks.installer.util.InstallerTool;
import nl.sivworks.installer.util.Logger;
import nl.sivworks.io.FileTool;
import nl.sivworks.text.Text;
import nl.sivworks.util.Environment;
import nl.sivworks.util.SystemCommand;

public final class InstallerSystem {
    private static final String LINUX_PROGRAM_DIRECTORY = "/usr/local";
    private static final String MAC_PROGRAM_DIRECTORY = "/usr/local";
    private static final String WINDOWS_PROGRAM_DIRECTORY = "C:/Program Files";
    private static final String WINDOWS_ALTERNATIVE_DIRECTORY = "C:/";
    private static final String WINDOWS_DESKTOP = "Desktop";
    private static final String WINDOWS_PROGRAMS = "Programs";
    private static final String WINDOWS_SHORTCUT_EXTENSION = ".lnk";
    private static final String UNINSTALLER_NAME = "Uninstaller";
    private static final File TMP_DIRECTORY = new File(FileTool.getTemporaryDirectory(), "QzBaq1287401");

    private InstallerSystem() {
    }

    public static File getTemporaryDirectory() {
        return TMP_DIRECTORY;
    }

    public static Logger createLogger(String fileName) {
        return new Logger(new File(TMP_DIRECTORY, fileName));
    }

    public static File getDefaultRoot() {
        if (Environment.isWindows()) {
            File file = new File(WINDOWS_PROGRAM_DIRECTORY);
            if (file.isDirectory() && Files.isWritable(file.toPath())) {
                return file;
            }
            return new File(WINDOWS_ALTERNATIVE_DIRECTORY);
        }
        if (Environment.isLinux()) {
            if (InstallerSystem.getSudoUser() != null) {
                return new File("/usr/local");
            }
            return Environment.getUserHome();
        }
        if (Environment.isMac()) {
            if (InstallerSystem.getSudoUser() != null) {
                return new File("/usr/local");
            }
            return Environment.getUserHome();
        }
        return null;
    }

    public static String getInstallerJarName(String name, String version) {
        return InstallerSystem.createFileName(name, version) + ".jar";
    }

    public static String getInstallerName(String name, String version, Environment.OsGroup group) {
        return switch (group) {
            default -> throw new MatchException(null, null);
            case Environment.OsGroup.WINDOWS -> InstallerSystem.createFileName(name, version) + ".exe";
            case Environment.OsGroup.LINUX -> InstallerSystem.createFileName(name, version) + ".sh";
            case Environment.OsGroup.MAC -> InstallerSystem.createFileName(name, version) + ".command";
        };
    }

    public static String getUninstallerJarName() {
        return "Uninstaller.jar";
    }

    public static String getUninstallerTemplateName() {
        return "Uninstaller.template";
    }

    public static String getUninstallerDataFileName() {
        return "Uninstaller.data";
    }

    public static String getUninstallerName(Environment.OsGroup group) {
        return switch (group) {
            default -> throw new MatchException(null, null);
            case Environment.OsGroup.WINDOWS -> "Uninstaller.exe";
            case Environment.OsGroup.LINUX -> "Uninstaller.sh";
            case Environment.OsGroup.MAC -> "Uninstaller.command";
        };
    }

    public static String getSudoUser() {
        return System.getenv("SUDO_USER");
    }

    public static List<File> addShortcuts(File home, List<Shortcut> shortcuts) throws InstallerException, IOException {
        if (Environment.isWindows()) {
            return InstallerSystem.createWindowsShortcuts(home, shortcuts);
        }
        if (Environment.isLinux()) {
            return InstallerSystem.createLinuxShortcuts(home, shortcuts);
        }
        return Collections.emptyList();
    }

    private static List<File> createWindowsShortcuts(File home, List<Shortcut> shortcuts) throws InstallerException {
        String architecture = System.getProperty("os.arch");
        String libraryName = null;
        for (String item : InstallerConstants.JSHORTCUT_DLL_FILES) {
            if (!item.contains(architecture)) continue;
            libraryName = item;
            break;
        }
        if (libraryName == null) {
            return Collections.emptyList();
        }
        File directory = FileTool.getTemporaryDirectory();
        File outputFile = new File(directory, "jshortcut.dll");
        try (InputStream source = InstallerSystem.class.getResourceAsStream("/" + libraryName);
             FileOutputStream destination = new FileOutputStream(outputFile);){
            FileTool.copy(source, destination);
            System.setProperty("JSHORTCUT_HOME", directory.toString());
        }
        catch (Exception exc) {
            throw new InstallerException(Text.get("Msg|ReadShortcutDllError", new Object[0]), exc);
        }
        ArrayList<File> list = new ArrayList<File>();
        for (Shortcut shortcut : shortcuts) {
            list.addAll(InstallerSystem.createWindowsShortcut(home, shortcut));
        }
        return list;
    }

    private static List<File> createWindowsShortcut(File home, Shortcut shortcut) throws InstallerException {
        ArrayList<File> list = new ArrayList<File>();
        JShellLink link = new JShellLink();
        link.setName(shortcut.getName());
        link.setPath(new File(home, shortcut.getPath()).getPath());
        link.setFolder(JShellLink.getDirectory(WINDOWS_DESKTOP));
        link.save();
        list.add(new File(new File(JShellLink.getDirectory(WINDOWS_DESKTOP)), shortcut.getName() + WINDOWS_SHORTCUT_EXTENSION));
        File startDirectory = new File(JShellLink.getDirectory(WINDOWS_PROGRAMS));
        if (startDirectory.isDirectory()) {
            File targetFolder = startDirectory;
            if (shortcut.getTarget() != null && !shortcut.getTarget().isEmpty() && !(targetFolder = new File(startDirectory, shortcut.getTarget())).exists()) {
                list.addAll(InstallerTool.createDirectories(targetFolder));
            }
            link.setFolder(targetFolder.getPath());
            link.save();
            list.add(new File(targetFolder, shortcut.getName() + WINDOWS_SHORTCUT_EXTENSION));
        }
        return list;
    }

    private static List<File> createLinuxShortcuts(File home, List<Shortcut> shortcuts) throws IOException, InstallerException {
        boolean sudo;
        ArrayList<File> list = new ArrayList<File>();
        String user = InstallerSystem.getSudoUser();
        boolean bl = sudo = user != null;
        if (user == null) {
            user = Environment.getUserName();
        }
        File userHome = new File("/home", user);
        File applicationsDirectory = null;
        applicationsDirectory = sudo ? new File("/usr/share/applications") : new File(userHome, ".local/share/applications");
        if (!applicationsDirectory.isDirectory()) {
            applicationsDirectory = new File(home, "desktop");
            list.addAll(InstallerTool.createDirectories(applicationsDirectory));
        }
        ArrayList<File> shortcutFiles = new ArrayList<File>();
        try {
            for (Shortcut shortcut : shortcuts) {
                File file = InstallerSystem.createLinuxShortcut(home, shortcut, applicationsDirectory);
                list.add(file);
                shortcutFiles.add(file);
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        if (shortcutFiles.isEmpty() || !userHome.isDirectory()) {
            return list;
        }
        File infoFile = new File(userHome, ".config/user-dirs.dirs");
        if (!infoFile.isFile()) {
            return list;
        }
        try {
            for (String line : Files.readAllLines(infoFile.toPath())) {
                if (!line.startsWith("XDG_DESKTOP_DIR=")) continue;
                String path = line.substring("XDG_DESKTOP_DIR=".length()).replace("\"", "");
                File desktop = path.startsWith("$HOME/") ? new File(userHome, path.substring("$HOME/".length())) : new File(path);
                if (desktop.isDirectory() && !desktop.equals(userHome)) {
                    PosixFileAttributes attributes = Files.readAttributes(desktop.toPath(), PosixFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                    UserPrincipal owner = attributes.owner();
                    GroupPrincipal group = attributes.group();
                    String address = null;
                    if (sudo) {
                        address = "DBUS_SESSION_BUS_ADDRESS=unix:path=/run/user/" + InstallerSystem.getUid(user) + "/bus";
                    }
                    for (File file : shortcutFiles) {
                        File target = new File(desktop, file.getName());
                        FileTool.copy(file, target);
                        list.add(target);
                        if (sudo) {
                            PosixFileAttributeView view = Files.getFileAttributeView(target.toPath(), PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
                            view.setOwner(owner);
                            view.setGroup(group);
                        }
                        target.setExecutable(true);
                        SystemCommand command = sudo ? new SystemCommand("sudo", "-u", user, address, "gio", "set", target.getPath(), "metadata::trusted", "true") : new SystemCommand("gio", "set", target.getPath(), "metadata::trusted", "true");
                        try {
                            command.execute();
                            if (command.getExitValue() == 0) continue;
                            System.out.println("Problem handling desktop shortcut file: " + String.valueOf(target));
                            System.out.println("Command errors: " + String.valueOf(command.getErrors()));
                        }
                        catch (Exception exc) {
                            exc.printStackTrace();
                        }
                    }
                }
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return list;
    }

    private static File createLinuxShortcut(File home, Shortcut shortcut, File directory) throws IOException, InstallerException {
        ArrayList<Object> lines = new ArrayList<Object>();
        lines.add("#!/usr/bin/env xdg-open");
        lines.add("[Desktop Entry]");
        lines.add("Version=1.0");
        lines.add("Type=Application");
        lines.add("Terminal=false");
        lines.add("Name=" + shortcut.getName());
        lines.add("Exec=" + String.valueOf(home) + "/" + shortcut.getPath());
        lines.add("Icon=" + String.valueOf(home) + "/" + shortcut.getIcon());
        lines.add("StartupWMClass=" + shortcut.getStartClass().replace(".", "-"));
        File file = new File(directory, shortcut.getTarget());
        Files.write(file.toPath(), lines, new OpenOption[0]);
        return file;
    }

    private static String getUid(String user) {
        SystemCommand command = new SystemCommand("sudo", "id", "-u", user);
        String id = null;
        try {
            command.execute();
            if (command.getExitValue() != 0) {
                System.out.println("Problem retrieving user ID for: " + user);
                System.out.println("Command errors: " + String.valueOf(command.getErrors()));
            } else {
                List<String> outputs = command.getOutputs();
                if (outputs != null && !outputs.isEmpty()) {
                    id = outputs.get(0);
                }
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return id;
    }

    private static String createFileName(String name, String version) {
        return name + "-" + version;
    }
}

