/*
 * Decompiled with CFR 0.152.
 */
package nl.sivworks.installer.runtime;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import nl.sivworks.installer.runtime.ActionPanel;
import nl.sivworks.installer.runtime.Installer;
import nl.sivworks.text.Text;

public final class LicensePanel
extends ActionPanel {
    private JCheckBox agreeBox;
    private final Installer installer;
    private final String licenseText;

    public LicensePanel(Installer installer) {
        this.installer = installer;
        Map<String, Object> configuration = installer.getConfiguration();
        this.licenseText = (String)configuration.get("License");
        if (!this.isToBeDisplayed()) {
            return;
        }
        JTextArea textArea = new JTextArea();
        textArea.setFont(new Font("SansSerif", 0, 12));
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setEditable(false);
        textArea.setText(this.licenseText);
        JScrollPane scrollPane = new JScrollPane(textArea);
        scrollPane.setPreferredSize(new Dimension(525, 200));
        this.agreeBox = new JCheckBox(Text.get("Field|AcceptLicense", new Object[0]));
        this.setBorder(new EmptyBorder(0, 10, 0, 10));
        this.setLayout(new BorderLayout(0, 10));
        this.add(scrollPane);
        this.add((Component)this.agreeBox, "South");
    }

    @Override
    public boolean isToBeDisplayed() {
        return this.licenseText != null && this.licenseText.length() != 0;
    }

    @Override
    public boolean isAllowedToContinue() {
        if (this.isToBeDisplayed() && !this.agreeBox.isSelected()) {
            this.installer.showMessage(Text.get("Msg|AcceptLicense", new Object[0]));
            return false;
        }
        return true;
    }
}

