/*
 * Decompiled with CFR 0.152.
 */
package nl.sivworks.installer.runtime;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import nl.sivworks.application.gui.components.TextPanel;
import nl.sivworks.installer.data.InstallMap;
import nl.sivworks.installer.data.PackageModule;
import nl.sivworks.installer.data.PreInstallCheck;
import nl.sivworks.installer.runtime.ActionPanel;
import nl.sivworks.installer.runtime.CheckWorker;
import nl.sivworks.installer.runtime.Installer;
import nl.sivworks.installer.util.InstallerSystem;
import nl.sivworks.io.FileTool;
import nl.sivworks.text.DefaultTextHolder;
import nl.sivworks.text.Text;
import nl.sivworks.util.Environment;

public final class DirectoryPanel
extends ActionPanel {
    private final JTextField directoryField;
    private final Installer installer;
    private final Map<String, Object> configuration;
    private final InstallMap map;

    public DirectoryPanel(Installer installer) {
        this.installer = installer;
        this.configuration = installer.getConfiguration();
        this.map = (InstallMap)this.configuration.get("Install Map");
        this.directoryField = new JTextField("", 30);
        this.directoryField.setEditable(false);
        JButton changeButton = new JButton(Text.get("Button|Change", new Object[0]));
        changeButton.addActionListener(new ButtonHandler(this));
        this.setLayout(new MigLayout("insets 0, gapx 15!, gapy 20!"));
        this.add((Component)new TextPanel(new DefaultTextHolder("Msg|DirectoryPanel", new Object[0])), "spanx 2, wrap");
        this.add(this.directoryField);
        this.add(changeButton);
        this.setRoot(InstallerSystem.getDefaultRoot());
    }

    private void setRoot(File root) {
        if (root.getName().equals(this.map.getBaseDirectory())) {
            this.directoryField.setText(root.getPath());
        } else {
            this.directoryField.setText(new File(root, this.map.getBaseDirectory()).getPath());
        }
    }

    @Override
    public boolean isAllowedToContinue() {
        File home = new File(this.directoryField.getText());
        if (!this.isAllowedToInstall(home)) {
            return false;
        }
        if (!this.isSafeToInstall()) {
            return false;
        }
        this.configuration.put("Home Directory", home);
        return true;
    }

    private boolean isAllowedToInstall(File home) {
        if (!Environment.isWindows() && home.getPath().contains(" ")) {
            this.installer.showError(Text.get("Msg|SpaceNotAllowed", new Object[0]));
            return false;
        }
        if (home.isFile()) {
            this.installer.showError(Text.get("Msg|CannotInstall|ConflictingFile", home));
            return false;
        }
        if (home.isDirectory()) {
            PreInstallCheck check = this.map.getPreInstallCheck();
            if (check == null) {
                return true;
            }
            ArrayList<File> foreignFiles = new ArrayList<File>();
            for (File file : FileTool.listFiles(home)) {
                if (check.containsName(file.getName())) continue;
                foreignFiles.add(file);
            }
            if (!foreignFiles.isEmpty()) {
                Object text = "";
                for (File file : foreignFiles) {
                    text = (String)text + "\n" + file.getPath();
                }
                this.installer.showError(Text.get("Msg|CannotInstall|UnexpectedContent", text));
                return false;
            }
        } else {
            File test;
            for (test = home; test != null && !test.isDirectory(); test = test.getParentFile()) {
            }
            try {
                if (test != null) {
                    Path path = Files.createTempDirectory(test.toPath(), "ATM", new FileAttribute[0]);
                    Files.delete(path);
                }
            }
            catch (Exception exc) {
                Object text = Text.get("Msg|CannotInstall|DirectoryProblem", test);
                if (FileTool.isCausedByAccessDenied(exc)) {
                    text = (String)text + " (" + Text.get("Msg|AccessDenied", new Object[0]) + ")";
                }
                this.installer.showMessage((String)text);
                return false;
            }
        }
        return true;
    }

    public boolean isSafeToInstall() {
        if (this.map.getPreInstallCheck() == null) {
            return true;
        }
        CheckWorker worker = new CheckWorker(this.map);
        worker.execute();
        try {
            List modules = (List)worker.get();
            if (!modules.isEmpty()) {
                Object text = "";
                for (PackageModule module : modules) {
                    text = (String)text + module.getTitle() + "\n";
                }
                this.installer.showError(Text.get("Msg|CannotInstall|ModuleIsRunning", text));
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    private class ButtonHandler
    implements ActionListener {
        private JFileChooser fileChooser;
        final /* synthetic */ DirectoryPanel this$0;

        private ButtonHandler(DirectoryPanel directoryPanel) {
            DirectoryPanel directoryPanel2 = directoryPanel;
            Objects.requireNonNull(directoryPanel2);
            this.this$0 = directoryPanel2;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int result;
            File file;
            if (this.fileChooser == null) {
                this.fileChooser = new JFileChooser();
                this.fileChooser.setDialogTitle(Text.get("Title|SelectDirectory", new Object[0]));
                this.fileChooser.setFileSelectionMode(1);
            }
            if ((file = InstallerSystem.getDefaultRoot()).isDirectory()) {
                this.fileChooser.setCurrentDirectory(file);
            }
            if ((result = this.fileChooser.showDialog(this.this$0.installer, Text.get("Button|Select", new Object[0]))) == 0 && this.fileChooser.getSelectedFile() != null) {
                this.this$0.setRoot(this.fileChooser.getSelectedFile());
            }
        }
    }
}

