/*
 * Decompiled with CFR 0.152.
 */
package nl.sivworks.application.gui.components;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.SwingConstants;
import nl.sivworks.application.gui.components.EPanel;
import nl.sivworks.text.SimpleTextHolder;
import nl.sivworks.text.TextHolder;
import nl.sivworks.util.StringTool;

public class TextPanel
extends EPanel
implements SwingConstants {
    private static final String[] EMPTY = new String[]{""};
    private TextHolder textHolder;
    private int horizontalAlignment = 10;
    private Font textFont;

    public TextPanel() {
        this((TextHolder)null);
    }

    public TextPanel(TextHolder textHolder) {
        this.setTextHolder(textHolder);
    }

    public String getText() {
        if (this.textHolder != null) {
            return this.textHolder.toString();
        }
        return null;
    }

    public void setText(String text) {
        if (text == null) {
            this.setTextHolder(null);
        } else {
            this.setTextHolder(new SimpleTextHolder(text));
        }
    }

    public TextHolder getTextHolder() {
        return this.textHolder;
    }

    public void setTextHolder(TextHolder textHolder) {
        this.textHolder = textHolder;
        if (textHolder == null) {
            this.displayText(EMPTY);
        } else {
            this.displayText(StringTool.getTokens(textHolder.toString(), '\n'));
        }
    }

    @Override
    public void updateUI() {
        if (this.textHolder != null) {
            this.displayText(StringTool.getTokens(this.textHolder.toString(), '\n'));
        }
        super.updateUI();
    }

    @Override
    public void setFont(Font font) {
        this.textFont = font;
        super.setFont(font);
        for (Component component : this.getComponents()) {
            if (!(component instanceof JLabel)) continue;
            component.setFont(font);
        }
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        for (Component component : this.getComponents()) {
            if (!(component instanceof JLabel)) continue;
            JLabel label = (JLabel)component;
            label.setHorizontalAlignment(horizontalAlignment);
        }
    }

    private void displayText(String[] text) {
        this.removeAll();
        if (text.length > 0) {
            this.setLayout(new GridLayout(text.length, 0));
            for (String line : text) {
                this.add(new JLabel(line, this.horizontalAlignment));
            }
            if (this.textFont != null) {
                this.setFont(this.textFont);
            }
        }
        this.repaint();
    }
}

