/*
 * Decompiled with CFR 0.152.
 */
package nl.sivworks.util;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import nl.sivworks.io.FileTool;
import nl.sivworks.util.Environment;

public final class ProductEnvironment {
    private static final String DEVELOPMENT_NAME = "SivWorks";
    private static final String REGISTRY_FILE = ".Registry";
    private static final String WINDOWS_SETTINGS_DIRECTORY = "AppData/Local";
    private static File productHome;
    private static File administrationDirectory;
    private static File logDirectory;

    private ProductEnvironment() {
    }

    public static File getHome() {
        if (productHome == null) {
            File file;
            for (file = FileTool.getEnclosingFile(ProductEnvironment.class).getParentFile(); file != null && !ProductEnvironment.getRegistryFile(file).exists(); file = file.getParentFile()) {
            }
            productHome = file;
        }
        if (productHome == null) {
            throw new IllegalStateException("Registry file not found");
        }
        return productHome;
    }

    public static File getUserAdministrationDirectory() {
        if (administrationDirectory == null) {
            File directory;
            String productName = null;
            File file = new File(ProductEnvironment.getHome(), REGISTRY_FILE);
            try {
                List<String> lines = Files.readAllLines(file.toPath());
                if (!lines.isEmpty()) {
                    productName = lines.get(0);
                }
            }
            catch (Exception lines) {
                // empty catch block
            }
            if (productName == null) {
                productName = ProductEnvironment.getHome().getName();
            }
            if (Environment.isWindows() && (directory = new File(Environment.getUserHome(), WINDOWS_SETTINGS_DIRECTORY)).isDirectory()) {
                administrationDirectory = new File(directory, productName);
                ProductEnvironment.upgradeToVersion_8_1(new File(Environment.getUserHome(), "." + productName), administrationDirectory);
            }
            if (administrationDirectory == null) {
                administrationDirectory = new File(Environment.getUserHome(), "." + productName);
            }
        }
        return administrationDirectory;
    }

    public static File getLogDirectory() {
        if (logDirectory == null) {
            logDirectory = new File(ProductEnvironment.getUserAdministrationDirectory(), "log");
        }
        return logDirectory;
    }

    private static void upgradeToVersion_8_1(File oldDirectory, File newDirectory) {
        if (!oldDirectory.isDirectory() || newDirectory.isDirectory()) {
            return;
        }
        try {
            Files.createDirectories(newDirectory.toPath(), new FileAttribute[0]);
            for (File file : oldDirectory.listFiles()) {
                if (file.isFile()) {
                    FileTool.copyToDirectory(file, newDirectory);
                    continue;
                }
                if (!file.isDirectory()) continue;
                FileTool.copyDirectory(file, newDirectory);
            }
            FileTool.removeDirectory(oldDirectory);
        }
        catch (Exception exc) {
            System.out.println("Failed to upgrade from " + String.valueOf(oldDirectory) + " to " + String.valueOf(newDirectory));
            exc.printStackTrace();
        }
    }

    public static File getRegistryFile(File home) {
        return new File(home, REGISTRY_FILE);
    }

    public static boolean isDevelopment() {
        return ProductEnvironment.getHome().getName().equals(DEVELOPMENT_NAME);
    }
}

