/*
 * Decompiled with CFR 0.152.
 */
package nl.sivworks.util;

import java.util.Locale;

public final class LocaleTool {
    private static final Locale DUTCH = LocaleTool.createLocale("nl");
    private static final Locale NORWEGIAN = LocaleTool.createLocale("no");
    private static final Locale[] PROGRAM_LOCALES = new Locale[]{LocaleTool.getEnglish(), LocaleTool.getDutch(), LocaleTool.getGerman()};

    private LocaleTool() {
    }

    public static Locale[] getProgramLocales() {
        return PROGRAM_LOCALES;
    }

    public static Locale getDefaultProgramLocale() {
        Locale locale = Locale.getDefault();
        for (Locale l : PROGRAM_LOCALES) {
            if (!locale.getLanguage().equals(l.getLanguage())) continue;
            return l;
        }
        return LocaleTool.getEnglish();
    }

    public static Locale createLocale(String language) {
        String[] parts = language.split("_");
        if (parts.length == 1) {
            return Locale.of(parts[0]);
        }
        if (parts.length == 2) {
            return Locale.of(parts[0], parts[1]);
        }
        if (parts.length == 3) {
            return Locale.of(parts[0], parts[1], parts[2]);
        }
        return null;
    }

    public static Locale getDutch() {
        return DUTCH;
    }

    public static Locale getEnglish() {
        return Locale.US;
    }

    public static Locale getNorwegian() {
        return NORWEGIAN;
    }

    public static Locale getGerman() {
        return Locale.GERMAN;
    }

    public static Locale getFrench() {
        return Locale.FRENCH;
    }
}

