/*
 * Decompiled with CFR 0.152.
 */
package nl.sivworks.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import nl.sivworks.io.FileTool;
import nl.sivworks.text.Text;

public class ZipFileUpdater {
    private static final char SLASH = '/';
    private static final char BACKSLASH = '\\';
    private final FileOutputStream outputStream;
    private final ZipOutputStream zipStream;

    public ZipFileUpdater(File zipFile) throws IOException {
        File sourceFile = ZipFileUpdater.getBackupFile(zipFile);
        sourceFile.deleteOnExit();
        Files.move(zipFile.toPath(), sourceFile.toPath(), new CopyOption[0]);
        ZipInputStream inStream = new ZipInputStream(new FileInputStream(sourceFile));
        this.outputStream = new FileOutputStream(zipFile);
        this.zipStream = new ZipOutputStream(this.outputStream);
        this.copy(inStream);
    }

    public void add(String fileName) throws IOException {
        this.add(null, fileName);
    }

    public void add(File path, String fileName) throws IOException {
        this.storeFile(path, fileName);
    }

    public synchronized void addEntry(ZipEntry entry, byte[] data) throws IOException {
        this.zipStream.putNextEntry(entry);
        this.zipStream.write(data, 0, data.length);
        this.zipStream.closeEntry();
    }

    public synchronized void close() throws IOException {
        this.zipStream.close();
        this.outputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(ZipInputStream inStream) throws IOException {
        try {
            ZipEntry zipEntry;
            while ((zipEntry = inStream.getNextEntry()) != null) {
                byte[] entryData = new byte[]{};
                if (!zipEntry.isDirectory()) {
                    entryData = FileTool.readByteStream(inStream);
                }
                this.addEntry(zipEntry, entryData);
            }
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.closeEntry();
                }
            }
            catch (IOException iOException) {}
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void storeFile(File path, String fileName) throws IOException {
        int index;
        File file;
        if (path == null) {
            file = new File(fileName);
            index = -1;
        } else {
            file = new File(path, fileName);
            index = path.getPath().length() + 1;
        }
        for (File f : FileTool.getFilesAndDirectories(file)) {
            Object entryName = f.getPath();
            if (index != -1) {
                entryName = ((String)entryName).substring(index);
            }
            if (f.isDirectory()) {
                entryName = (String)entryName + File.separator;
            }
            this.addToZip(f, ((String)entryName).replace('\\', '/'));
        }
    }

    private void addToZip(File file, String entryName) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException(Text.get("Msg|FileNotFound", file));
        }
        ZipEntry zipEntry = new ZipEntry(entryName);
        zipEntry.setTime(file.lastModified());
        if (file.isDirectory() || file.length() == 0L) {
            zipEntry.setMethod(0);
            zipEntry.setSize(0L);
            zipEntry.setCrc(0L);
        }
        byte[] entryData = new byte[]{};
        if (file.isFile() && file.length() > 0L) {
            entryData = Files.readAllBytes(file.toPath());
        }
        this.addEntry(zipEntry, entryData);
    }

    private static File getBackupFile(File file) {
        File bakFile = new File(file.getPath() + ".bak");
        int i = 1;
        while (bakFile.exists()) {
            bakFile = new File(file.getPath() + ".bak" + i++);
        }
        return bakFile;
    }
}

