/*
 * Decompiled with CFR 0.152.
 */
package nl.sivworks.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public final class CharsetTool {
    private static final int[] UTF_8_BOM = new int[]{239, 187, 191};
    private static final int[] UTF_16BE_BOM = new int[]{254, 255};
    private static final int[] UTF_16LE_BOM = new int[]{255, 254};
    private static final int BOM_CHECK_SIZE = 3;

    private CharsetTool() {
    }

    public static Charset determineCharset(File file) throws IOException {
        if (file.length() < 3L) {
            return null;
        }
        try (FileInputStream input = new FileInputStream(file);){
            int[] firstFewBytes = new int[3];
            for (int i = 0; i < 3; ++i) {
                firstFewBytes[i] = ((InputStream)input).read();
            }
            if (Arrays.equals(firstFewBytes, UTF_8_BOM)) {
                Charset charset = StandardCharsets.UTF_8;
                return charset;
            }
            if (Arrays.equals(firstFewBytes, 0, UTF_16BE_BOM.length, UTF_16BE_BOM, 0, UTF_16BE_BOM.length)) {
                Charset charset = StandardCharsets.UTF_16BE;
                return charset;
            }
            if (Arrays.equals(firstFewBytes, 0, UTF_16LE_BOM.length, UTF_16LE_BOM, 0, UTF_16LE_BOM.length)) {
                Charset charset = StandardCharsets.UTF_16LE;
                return charset;
            }
        }
        return null;
    }

    public static String decodeFromUtf8(String text) throws CharacterCodingException {
        return CharsetTool.decodeFromUtf8(ByteBuffer.wrap(text.getBytes()));
    }

    public static String decodeFromUtf8(ByteBuffer buffer) throws CharacterCodingException {
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
        return decoder.decode(buffer).toString();
    }

    public static ByteBuffer encodeToUtf8(String text) throws CharacterCodingException {
        return CharsetTool.encodeToUtf8(CharBuffer.wrap(text));
    }

    public static ByteBuffer encodeToUtf8(CharBuffer buffer) throws CharacterCodingException {
        CharsetEncoder encoder = StandardCharsets.UTF_8.newEncoder();
        return encoder.encode(buffer);
    }
}

