/*
 * Decompiled with CFR 0.152.
 */
package nl.sivworks.installer.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import nl.sivworks.io.FileTool;
import nl.sivworks.text.Text;

public final class JarFileWriter {
    private static final char DOT = '.';
    private static final char SLASH = '/';
    private static final char BACKSLASH = '\\';
    private final File jarFile;
    private Manifest manifest;
    private JarOutputStream zipStream;

    public JarFileWriter(File jarFile) {
        this.jarFile = jarFile;
        this.manifest = JarFileWriter.createDefaultManifest();
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public void setManifest(Manifest manifest) {
        if (this.zipStream != null) {
            throw new IllegalStateException("Too late to set manifest!");
        }
        this.manifest = manifest;
    }

    public void setManifestMainAttributes(Attributes attributes) throws IllegalStateException {
        if (this.zipStream != null) {
            throw new IllegalStateException("Too late to set manifest attributes");
        }
        Attributes mainAttributes = this.manifest.getMainAttributes();
        mainAttributes.putAll((Map<?, ?>)attributes);
    }

    public void setManifestPackageAttributes(String name, Attributes attributes) throws IllegalStateException {
        if (this.zipStream != null) {
            throw new IllegalStateException("Too late to set manifest package attributes");
        }
        String path = name.replace('.', '/').replace('\\', '/').trim();
        if (!path.endsWith("/")) {
            path = path.concat("/");
        }
        Map<String, Attributes> map = this.manifest.getEntries();
        map.put(path, attributes);
    }

    public void add(File path, String fileName) throws IOException {
        int index;
        File file;
        if (path == null) {
            file = new File(fileName);
            index = -1;
        } else {
            file = new File(path, fileName);
            index = path.getPath().length() + 1;
        }
        if (!file.exists()) {
            throw new FileNotFoundException(Text.get("Msg|FileNotFound", file));
        }
        for (File f : FileTool.getFilesAndDirectories(file)) {
            Object entryName = f.getPath();
            if (index != -1) {
                entryName = ((String)entryName).substring(index);
            }
            if (f.isDirectory()) {
                entryName = (String)entryName + File.separator;
            }
            this.addEntry(f, (String)entryName);
        }
    }

    public void addEntry(File file, String entryName) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException(Text.get("Msg|FileNotFound", file));
        }
        ZipEntry zipEntry = new ZipEntry(entryName.replace('\\', '/'));
        zipEntry.setTime(file.lastModified());
        if (file.isDirectory() || file.length() == 0L) {
            zipEntry.setMethod(0);
            zipEntry.setSize(0L);
            zipEntry.setCrc(0L);
        }
        byte[] data = file.isDirectory() || file.length() == 0L ? new byte[]{} : Files.readAllBytes(file.toPath());
        this.addEntry(zipEntry, data);
    }

    public void addEntry(ZipEntry entry, byte[] data) throws IOException {
        if (this.zipStream == null) {
            this.zipStream = this.manifest == null ? new JarOutputStream(new BufferedOutputStream(new FileOutputStream(this.jarFile))) : new JarOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(this.jarFile)), this.manifest);
        }
        this.zipStream.putNextEntry(entry);
        this.zipStream.write(data, 0, data.length);
        this.zipStream.closeEntry();
    }

    public void close() throws IOException {
        if (this.zipStream != null) {
            this.zipStream.close();
        }
    }

    private static Manifest createDefaultManifest() {
        Manifest defaultManifest = new Manifest();
        Attributes attributes = defaultManifest.getMainAttributes();
        if (!attributes.containsKey("Created-By")) {
            String version = System.getProperty("java.version");
            String vendor = System.getProperty("java.vendor");
            attributes.put(new Attributes.Name("Created-By"), version + " (" + vendor + ")");
        }
        if (!attributes.containsKey(Attributes.Name.MANIFEST_VERSION)) {
            attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        }
        return defaultManifest;
    }
}

