/*
 * Decompiled with CFR 0.152.
 */
package nl.sivworks.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import nl.sivworks.io.FileTool;
import nl.sivworks.text.DefaultTextHolder;
import nl.sivworks.util.ApplicationException;
import nl.sivworks.util.XmlEntityResolver;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaderJDOMFactory;
import org.jdom2.input.sax.XMLReaders;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.xml.sax.EntityResolver;

public abstract class XmlConverter {
    private static final Charset UTF_8 = StandardCharsets.UTF_8;
    private static final String SAVE_EXTENSION = ".#save#";
    private static final String STANDARD_INDENT = "   ";
    protected static final String[] TRUE_VALUES = new String[]{"true", "yes", "on", "1"};
    protected static final String[] FALSE_VALUES = new String[]{"false", "no", "off", "0"};
    private static final SAXBuilder builder = new SAXBuilder((XMLReaderJDOMFactory)XMLReaders.DTDVALIDATING);
    private static final XmlEntityResolver entityResolver;
    private static final Format format;

    public static void addPublicId(String publicId, URL location) {
        entityResolver.addPublicId(publicId, location);
    }

    public static synchronized Document loadXml(URL url) throws ApplicationException {
        try {
            return builder.build(url);
        }
        catch (Exception exc) {
            throw new ApplicationException(new DefaultTextHolder("Msg|FailedToLoadXMLFromSource", url), (Throwable)exc);
        }
    }

    public static synchronized Document loadXml(URL url, String systemId) throws ApplicationException {
        Document document;
        block9: {
            if (url == null) {
                throw new IllegalArgumentException("URL is null");
            }
            InputStream inputStream = url.openStream();
            try {
                document = builder.build(inputStream, systemId);
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exc) {
                    throw new ApplicationException(new DefaultTextHolder("Msg|FailedToLoadXMLFromSource", url), (Throwable)exc);
                }
            }
            inputStream.close();
        }
        return document;
    }

    public static synchronized Document loadXml(File file) throws ApplicationException {
        try {
            return builder.build(file);
        }
        catch (Exception exc) {
            throw new ApplicationException(new DefaultTextHolder("Msg|FailedToLoadXMLFromSource", file), (Throwable)exc);
        }
    }

    protected static synchronized Document loadXml(Reader reader) throws ApplicationException {
        try {
            return builder.build(reader);
        }
        catch (Exception exc) {
            throw new ApplicationException(new DefaultTextHolder("Msg|FailedToLoadXML", new Object[0]), (Throwable)exc);
        }
    }

    protected static synchronized Document loadXml(Reader reader, String systemId) throws ApplicationException {
        try {
            return builder.build(reader, systemId);
        }
        catch (Exception exc) {
            throw new ApplicationException(new DefaultTextHolder("Msg|FailedToLoadXML", new Object[0]), (Throwable)exc);
        }
    }

    protected static synchronized Document loadXml(InputStream inputStream) throws ApplicationException {
        try {
            return builder.build(inputStream);
        }
        catch (Exception exc) {
            throw new ApplicationException(new DefaultTextHolder("Msg|FailedToLoadXML", new Object[0]), (Throwable)exc);
        }
    }

    public static void saveXml(File file, Document document) throws ApplicationException {
        if (!file.exists()) {
            FileTool.createDirectory(file.getParentFile());
        }
        File saveFile = new File(file.getPath() + SAVE_EXTENSION);
        try {
            XmlConverter.storeXml(saveFile, document);
            if (file.exists()) {
                file.delete();
            }
            saveFile.renameTo(file);
        }
        catch (Exception exc) {
            throw new ApplicationException(new DefaultTextHolder("Msg|FailedToSave", file), (Throwable)exc);
        }
    }

    protected static void storeXml(File file, Document document) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(file);
             BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream, UTF_8));){
            XMLOutputter outputter = new XMLOutputter(format);
            outputter.output(document, (Writer)writer);
        }
    }

    protected static String getXmlAsString(Document document) {
        XMLOutputter outputter = new XMLOutputter(format);
        StringWriter stringWriter = new StringWriter();
        try {
            outputter.output(document, (Writer)stringWriter);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    protected static String getXmlAsString(Element element) {
        XMLOutputter outputter = new XMLOutputter(format);
        StringWriter stringWriter = new StringWriter();
        try {
            outputter.output(element, (Writer)stringWriter);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    protected static String getString(Element element, String attribute) {
        return XmlConverter.getString(element, attribute, null);
    }

    protected static String getString(Element element, String attribute, String defaultValue) {
        String value = element.getAttributeValue(attribute);
        if (value == null) {
            return defaultValue;
        }
        return value.trim();
    }

    protected static int getInteger(Element element, String attribute) {
        return XmlConverter.getInteger(element, attribute, 0);
    }

    protected static int getInteger(Element element, String attribute, int defaultValue) {
        String value = element.getAttributeValue(attribute);
        if (value == null) {
            return defaultValue;
        }
        return (int)Double.parseDouble(value);
    }

    protected static double getDouble(Element element, String attribute) {
        return XmlConverter.getDouble(element, attribute, 0.0);
    }

    protected static double getDouble(Element element, String attribute, double defaultValue) {
        String value = element.getAttributeValue(attribute);
        if (value == null) {
            return defaultValue;
        }
        return Double.parseDouble(value);
    }

    protected static boolean getBoolean(Element element, String attribute) {
        return XmlConverter.getBoolean(element, attribute, false);
    }

    protected static boolean getBoolean(Element element, String attribute, boolean defaultValue) {
        String value = element.getAttributeValue(attribute);
        if (value == null) {
            return defaultValue;
        }
        value = value.trim();
        for (String trueValue : TRUE_VALUES) {
            if (!value.equalsIgnoreCase(trueValue)) continue;
            return true;
        }
        for (String falseValue : FALSE_VALUES) {
            if (!value.equalsIgnoreCase(falseValue)) continue;
            return false;
        }
        return defaultValue;
    }

    protected static String doubleToString(double value) {
        Object result;
        String text = Double.toString(value);
        int dot = text.indexOf(46);
        int exp = text.indexOf(69);
        int length = exp == -1 ? text.length() - dot : exp - dot;
        if (length > 5) {
            result = text.substring(0, dot + 5);
            if (exp != -1) {
                result = (String)result + text.substring(exp);
            }
        } else {
            result = text;
        }
        return result;
    }

    protected static String booleanToString(boolean value) {
        if (value) {
            return TRUE_VALUES[0];
        }
        return FALSE_VALUES[0];
    }

    static {
        builder.setReuseParser(true);
        entityResolver = new XmlEntityResolver();
        builder.setEntityResolver((EntityResolver)entityResolver);
        format = Format.getPrettyFormat();
        format.setIndent(STANDARD_INDENT);
    }
}

