/*
 * Decompiled with CFR 0.152.
 */
package nl.sivworks.util;

import java.io.File;
import nl.sivworks.util.ProductEnvironment;

public class PackageEnvironment {
    private static final String CONFIG = "config";
    private static final String LOGO = "logo";
    private static final String IMAGES = "images";
    private static final String LICENSE_FILE = "License.txt";
    private static final String FILE_HISTORY_FILE = "FileHistory.xml";

    public static File getHome(String packageName) {
        File home = ProductEnvironment.getHome();
        if (ProductEnvironment.isDevelopment()) {
            home = new File(home, packageName);
        }
        return home;
    }

    public static File getConfigDirectory(String packageName) {
        return new File(PackageEnvironment.getHome(packageName), CONFIG);
    }

    public static File getLogoDirectory(String packageName) {
        return new File(PackageEnvironment.getHome(packageName), LOGO);
    }

    public static File getImageDirectory(String packageName) {
        return new File(PackageEnvironment.getHome(packageName), IMAGES);
    }

    public static File getIconImageFile(String packageName) {
        return new File(PackageEnvironment.getLogoDirectory(packageName), packageName + ".png");
    }

    public static File getInfoScreenImageFile(String packageName) {
        return new File(PackageEnvironment.getLogoDirectory(packageName), packageName + "Screen.png");
    }

    public static File getProgramDataFile(String packageName) {
        return new File(PackageEnvironment.getConfigDirectory(packageName), packageName + "Data.xml");
    }

    public static File getLogFile(String packageName) {
        return new File(ProductEnvironment.getLogDirectory(), packageName + ".log");
    }

    public static File getLicenseFile(String packageName) {
        String path = CONFIG + File.separator + packageName + LICENSE_FILE;
        if (ProductEnvironment.isDevelopment()) {
            return new File(PackageEnvironment.getHome(packageName), path);
        }
        return new File(ProductEnvironment.getHome(), path);
    }

    public static File getFileHistoryFile(String program) {
        return new File(ProductEnvironment.getUserAdministrationDirectory(), program + FILE_HISTORY_FILE);
    }
}

