/*
 * Decompiled with CFR 0.152.
 */
package nl.sivworks.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import java.util.List;
import nl.sivworks.io.FileTool;

public final class UrlTool {
    private static final int TIMEOUT = 5000;
    private static final BitSet safeCharacters;
    private static final char[] hexadecimal;

    private UrlTool() {
    }

    public static URL encodePathToUrlRfc1738(String path) throws URISyntaxException, MalformedURLException {
        return UrlTool.encodePathToUri(path).toURL();
    }

    public static URI encodePathToUriRfc1738(String path) throws URISyntaxException {
        return new URI(UrlTool.encodePathRfc1738(path));
    }

    public static String encodePathRfc1738(String path) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(10);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)buffer, StandardCharsets.UTF_8);
        StringBuilder rewrittenPath = new StringBuilder(path.length());
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (safeCharacters.get(c)) {
                rewrittenPath.append(c);
                continue;
            }
            try {
                writer.write(c);
                writer.flush();
            }
            catch (IOException exc) {
                buffer.reset();
                continue;
            }
            for (byte toEncode : buffer.toByteArray()) {
                rewrittenPath.append('%');
                int low = toEncode & 0xF;
                int high = (toEncode & 0xF0) >> 4;
                rewrittenPath.append(hexadecimal[high]);
                rewrittenPath.append(hexadecimal[low]);
            }
            buffer.reset();
        }
        return rewrittenPath.toString();
    }

    public static URL encodePathToUrl(String path) throws URISyntaxException, MalformedURLException {
        return UrlTool.encodePathToUri(path).toURL();
    }

    public static URI encodePathToUri(String path) throws URISyntaxException {
        return new URI(UrlTool.encodePathSpaces(path));
    }

    public static String encodePathSpaces(String path) {
        return path.replace(" ", "%20");
    }

    public static String decodePathSpaces(String path) {
        return path.replace("%20", " ");
    }

    public static File getFile(URL url) {
        String fileName = url.getPath();
        if (fileName.startsWith("file:")) {
            fileName = fileName.substring("file:".length());
        }
        if (fileName.endsWith("!/")) {
            fileName = fileName.substring(0, fileName.length() - "!/".length());
        }
        return new File(UrlTool.decodePathSpaces(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readText(URL url, Charset charSet) throws IOException {
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            connection.connect();
            String string = FileTool.readText(connection.getInputStream(), charSet);
            return string;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static List<String> readTextLines(URL url, Charset charSet) throws IOException {
        return UrlTool.readTextLines(url, Integer.MAX_VALUE, charSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readTextLines(URL url, int lineCount, Charset charSet) throws IOException {
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            connection.connect();
            List<String> list = FileTool.readTextLines(connection.getInputStream(), lineCount, charSet);
            return list;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    static {
        int i;
        hexadecimal = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        safeCharacters = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            safeCharacters.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            safeCharacters.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            safeCharacters.set(i);
        }
        safeCharacters.set(36);
        safeCharacters.set(45);
        safeCharacters.set(95);
        safeCharacters.set(46);
        safeCharacters.set(43);
        safeCharacters.set(33);
        safeCharacters.set(42);
        safeCharacters.set(39);
        safeCharacters.set(40);
        safeCharacters.set(41);
        safeCharacters.set(44);
        safeCharacters.set(47);
        safeCharacters.set(58);
        safeCharacters.set(64);
        safeCharacters.set(38);
        safeCharacters.set(61);
        safeCharacters.set(35);
        safeCharacters.set(63);
        safeCharacters.set(37);
    }
}

