/*
 * Decompiled with CFR 0.152.
 */
package nl.sivworks.io;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.Arrays;

public class AnselCharset
extends Charset {
    private static final char[] ANSEL_CHARS = new char[256];
    private static final String[][] CONVERSION_TABLE = new String[][]{{"AEIOUaeiou", "\u00c0\u00c8\u00cc\u00d2\u00d9\u00e0\u00e8\u00ec\u00f2\u00f9"}, {"ACEILNORSUYZaceilnorsuyz", "\u00c1?\u00c9\u00cd??\u00d3??\u00da\u00dd?\u00e1?\u00e9\u00ed??\u00f3??\u00fa\u00fd?"}, {"ACEGHIJOSUWYaceghijosuwy", "\u00c2?\u00ca??\u00ce?\u00d4?\u00db??\u00e2?\u00ea??\u00ee?\u00f4?\u00fb??"}, {"AINOUainou", "\u00c3?\u00d1\u00d5?\u00e3?\u00f1\u00f5?"}, {"AEIOUaeiou", "??????????"}, {"AGUagu", "??????"}, {"CEGIZcegiz", "??????????"}, {"AEIOUYaeiouy", "\u00c4\u00cb\u00cf\u00d6\u00dc?\u00e4\u00eb\u00ef\u00f6\u00fc\u00ff"}, null, {"AUau", "\u00c5?\u00e5?"}, {"CGKLNRSTcgklnrst", "\u00c7???????\u00e7???????"}, null, {"OUou", "????"}, {"AEIUaeiu", "????????"}, {"CDELNRSTZcdelnrstz", "??????????????????"}, {"c", "\u00e7"}};

    public AnselCharset() {
        super("ANSEL", null);
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        throw new UnsupportedOperationException("ANSEL Encoding not supported");
    }

    @Override
    public boolean contains(Charset cs) {
        return this.displayName().equals(cs.displayName());
    }

    @Override
    public boolean canEncode() {
        return false;
    }

    static {
        for (int index = 0; index < 128; ++index) {
            AnselCharset.ANSEL_CHARS[index] = (char)index;
        }
        Arrays.fill(ANSEL_CHARS, 128, ANSEL_CHARS.length, '?');
        AnselCharset.ANSEL_CHARS[136] = 152;
        AnselCharset.ANSEL_CHARS[137] = 156;
        AnselCharset.ANSEL_CHARS[141] = 156;
        AnselCharset.ANSEL_CHARS[142] = 156;
        AnselCharset.ANSEL_CHARS[161] = 321;
        AnselCharset.ANSEL_CHARS[162] = 216;
        AnselCharset.ANSEL_CHARS[163] = 272;
        AnselCharset.ANSEL_CHARS[164] = 222;
        AnselCharset.ANSEL_CHARS[165] = 198;
        AnselCharset.ANSEL_CHARS[166] = 338;
        AnselCharset.ANSEL_CHARS[167] = 697;
        AnselCharset.ANSEL_CHARS[168] = 183;
        AnselCharset.ANSEL_CHARS[169] = 9837;
        AnselCharset.ANSEL_CHARS[170] = 174;
        AnselCharset.ANSEL_CHARS[171] = 177;
        AnselCharset.ANSEL_CHARS[172] = 416;
        AnselCharset.ANSEL_CHARS[173] = 431;
        AnselCharset.ANSEL_CHARS[174] = 700;
        AnselCharset.ANSEL_CHARS[176] = 699;
        AnselCharset.ANSEL_CHARS[177] = 322;
        AnselCharset.ANSEL_CHARS[178] = 248;
        AnselCharset.ANSEL_CHARS[179] = 273;
        AnselCharset.ANSEL_CHARS[180] = 254;
        AnselCharset.ANSEL_CHARS[181] = 230;
        AnselCharset.ANSEL_CHARS[182] = 339;
        AnselCharset.ANSEL_CHARS[183] = 698;
        AnselCharset.ANSEL_CHARS[184] = 305;
        AnselCharset.ANSEL_CHARS[185] = 163;
        AnselCharset.ANSEL_CHARS[186] = 240;
        AnselCharset.ANSEL_CHARS[188] = 417;
        AnselCharset.ANSEL_CHARS[189] = 432;
        AnselCharset.ANSEL_CHARS[192] = 176;
        AnselCharset.ANSEL_CHARS[193] = 8467;
        AnselCharset.ANSEL_CHARS[194] = 8471;
        AnselCharset.ANSEL_CHARS[195] = 169;
        AnselCharset.ANSEL_CHARS[196] = 9839;
        AnselCharset.ANSEL_CHARS[197] = 191;
        AnselCharset.ANSEL_CHARS[198] = 161;
        AnselCharset.ANSEL_CHARS[199] = 223;
        AnselCharset.ANSEL_CHARS[200] = 8364;
        AnselCharset.ANSEL_CHARS[224] = 777;
        AnselCharset.ANSEL_CHARS[225] = 768;
        AnselCharset.ANSEL_CHARS[226] = 769;
        AnselCharset.ANSEL_CHARS[227] = 770;
        AnselCharset.ANSEL_CHARS[228] = 771;
        AnselCharset.ANSEL_CHARS[229] = 772;
        AnselCharset.ANSEL_CHARS[230] = 774;
        AnselCharset.ANSEL_CHARS[231] = 775;
        AnselCharset.ANSEL_CHARS[232] = 776;
        AnselCharset.ANSEL_CHARS[233] = 780;
        AnselCharset.ANSEL_CHARS[234] = 778;
        AnselCharset.ANSEL_CHARS[235] = 865;
        AnselCharset.ANSEL_CHARS[236] = 65057;
        AnselCharset.ANSEL_CHARS[237] = 789;
        AnselCharset.ANSEL_CHARS[238] = 779;
        AnselCharset.ANSEL_CHARS[239] = 784;
        AnselCharset.ANSEL_CHARS[240] = 807;
        AnselCharset.ANSEL_CHARS[241] = 808;
        AnselCharset.ANSEL_CHARS[242] = 803;
        AnselCharset.ANSEL_CHARS[243] = 804;
        AnselCharset.ANSEL_CHARS[244] = 805;
        AnselCharset.ANSEL_CHARS[245] = 819;
        AnselCharset.ANSEL_CHARS[246] = 818;
        AnselCharset.ANSEL_CHARS[247] = 806;
        AnselCharset.ANSEL_CHARS[248] = 796;
        AnselCharset.ANSEL_CHARS[249] = 814;
        AnselCharset.ANSEL_CHARS[250] = 65058;
        AnselCharset.ANSEL_CHARS[251] = 65059;
        AnselCharset.ANSEL_CHARS[254] = 787;
        AnselCharset.ANSEL_CHARS[207] = 223;
    }

    private static class Decoder
    extends CharsetDecoder {
        private Decoder(Charset cs) {
            super(cs, 1.0f, 1.0f);
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
            while (in.hasRemaining()) {
                if (out.hasRemaining()) {
                    int b = in.get() & 0xFF;
                    if (b >= 225 && b <= 240) {
                        if (!in.hasRemaining()) continue;
                        byte nextByte = in.get();
                        String[] conversionTable = CONVERSION_TABLE[b - 225];
                        if (conversionTable == null) continue;
                        char[] inChars = conversionTable[0].toCharArray();
                        char[] outChars = conversionTable[1].toCharArray();
                        int length = inChars.length;
                        for (int i = 0; i < length; ++i) {
                            if (nextByte != inChars[i]) continue;
                            out.put(outChars[i]);
                        }
                        continue;
                    }
                    out.put(ANSEL_CHARS[b]);
                    continue;
                }
                return CoderResult.OVERFLOW;
            }
            return CoderResult.UNDERFLOW;
        }
    }
}

