/*
 * Decompiled with CFR 0.152.
 */
package nl.sivworks.installer.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import nl.sivworks.text.Text;

public final class NewLineConverter {
    public static void convert(File source, Format format) throws IOException {
        if (source.isDirectory()) {
            throw new IOException("Can't convert directory " + source.getPath());
        }
        if (!source.isFile()) {
            throw new FileNotFoundException(Text.get("Msg|FileNotFound", source));
        }
        File target = new File(String.valueOf(source) + ".tmp");
        try (BufferedReader reader = new BufferedReader(new FileReader(source));
             PrintWriter writer = new PrintWriter((Writer)new BufferedWriter(new FileWriter(target)), true);){
            String buffer;
            while ((buffer = reader.readLine()) != null) {
                writer.write(buffer + format.getEndOfLine());
            }
        }
        source.delete();
        if (!target.renameTo(source)) {
            throw new IOException("Unable to rename " + String.valueOf(target) + " to " + String.valueOf(source));
        }
    }

    public static enum Format {
        WINDOWS("\r\n"),
        UNIX("\n"),
        MAC("\n");

        private final String endOfLine;

        private Format(String endOfLine) {
            this.endOfLine = endOfLine;
        }

        public String getEndOfLine() {
            return this.endOfLine;
        }
    }
}

