/*
 * Decompiled with CFR 0.152.
 */
package nl.sivworks.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringTool {
    private static final String REGEX_LINE_SEPARATOR = "\\r?\\n";
    private static final String DEFAULT_DELIMITERS = " \t\n\r\n\f";
    private static final String PERL5_META_CHARACTERS = "'*?+[]()|^$.{}\\";
    private static final String GLOB_META_CHARACTERS = "*?[]";

    private StringTool() {
    }

    public static List<String> getLines(String text) {
        if (text == null || text.trim().isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.asList(text.split(REGEX_LINE_SEPARATOR));
    }

    public static boolean matches(String pattern, String text) {
        return StringTool.matches(pattern, text, true);
    }

    public static boolean matches(String pattern, String text, boolean isCaseSensitive) {
        Matcher matcher = isCaseSensitive ? Pattern.compile(StringTool.globToPerl5(pattern.toCharArray())).matcher(text) : Pattern.compile(StringTool.globToPerl5(pattern.toCharArray()), 2).matcher(text);
        return matcher.matches();
    }

    public static String[] getTokens(String str) {
        return StringTool.getTokens(str, Integer.MAX_VALUE);
    }

    public static String[] getTokens(String str, int maxTokens) {
        return StringTool.getTokens(str, DEFAULT_DELIMITERS, maxTokens);
    }

    public static String[] getTokens(String str, String delimiters, int maxTokens) {
        ArrayList<String> fields = new ArrayList<String>();
        int beginIndex = 0;
        int endIndex = 0;
        while (fields.size() < maxTokens && endIndex != -1 && beginIndex != -1) {
            if (fields.size() == maxTokens - 1) {
                fields.add(str.substring(beginIndex));
                break;
            }
            endIndex = StringTool.indexOfAnyOf(str, delimiters, beginIndex);
            if (endIndex != -1) {
                fields.add(str.substring(beginIndex, endIndex));
                beginIndex = StringTool.indexOfAnyBut(str, delimiters, endIndex + 1);
                continue;
            }
            if (beginIndex >= str.length()) continue;
            fields.add(str.substring(beginIndex));
        }
        return fields.toArray(new String[0]);
    }

    public static String[] getTokens(String str, char delimiter) {
        return StringTool.getTokens(str, delimiter, Integer.MAX_VALUE);
    }

    public static String[] getTokens(String str, String delimiters) {
        return StringTool.getTokens(str, delimiters, Integer.MAX_VALUE);
    }

    public static String[] getTokens(String str, char delimiter, int maxTokens) {
        ArrayList<String> fields = new ArrayList<String>();
        int beginIndex = 0;
        int endIndex = 0;
        while (fields.size() < maxTokens && endIndex != -1) {
            if (fields.size() == maxTokens - 1) {
                fields.add(str.substring(beginIndex));
                break;
            }
            endIndex = str.indexOf(delimiter, beginIndex);
            if (endIndex != -1) {
                fields.add(str.substring(beginIndex, endIndex));
                beginIndex = endIndex + 1;
                continue;
            }
            if (beginIndex >= str.length()) continue;
            fields.add(str.substring(beginIndex));
        }
        return fields.toArray(new String[0]);
    }

    private static boolean equals(char c1, char c2, boolean caseSensitive) {
        if (caseSensitive) {
            return c1 == c2;
        }
        return Character.toUpperCase(c1) == Character.toUpperCase(c2) || Character.toLowerCase(c1) == Character.toLowerCase(c2);
    }

    public static int occurrencesOf(String str, String c, boolean ignoreCase) {
        int count = 0;
        if (c.length() > 0) {
            int index;
            int start = 0;
            while ((index = StringTool.indexOf(str, c, start, ignoreCase)) >= 0) {
                ++count;
                start = index + c.length();
            }
        }
        return count;
    }

    private static int indexOf(String s, String c, int start, boolean ignoreCase) {
        if (ignoreCase) {
            int ls = s.length();
            int lc = c.length();
            int lc1 = lc - 1;
            int le = ls - lc;
            if (lc == 0 || start > le) {
                return -1;
            }
            char c0 = c.charAt(0);
            for (int ns = start < 0 ? 0 : start; ns < le + 1; ++ns) {
                if (!StringTool.equals(s.charAt(ns), c0, ignoreCase) || !s.regionMatches(ignoreCase, ns + 1, c, 1, lc1)) continue;
                return ns;
            }
            return -1;
        }
        return s.indexOf(c, start);
    }

    private static int indexOfAnyOf(String str, String set, int start) {
        int position = str.length();
        for (int i = 0; i < set.length(); ++i) {
            int index = str.indexOf(set.charAt(i), start);
            if (index < 0 || index >= position) continue;
            position = index;
        }
        if (position < str.length()) {
            return position;
        }
        return -1;
    }

    private static int indexOfAnyBut(String str, String set, int start) {
        for (int i = start; i < str.length(); ++i) {
            if (set.indexOf(str.charAt(i)) >= 0) continue;
            return i;
        }
        return -1;
    }

    public static String globToPerl5(char[] pattern) {
        StringBuilder buffer = new StringBuilder(2 * pattern.length);
        boolean inCharSet = false;
        block11: for (int ch = 0; ch < pattern.length; ++ch) {
            switch (pattern[ch]) {
                case '*': {
                    if (inCharSet) {
                        buffer.append('*');
                        continue block11;
                    }
                    buffer.append(".*");
                    continue block11;
                }
                case '?': {
                    if (inCharSet) {
                        buffer.append('?');
                        continue block11;
                    }
                    buffer.append('.');
                    continue block11;
                }
                case '[': {
                    inCharSet = true;
                    buffer.append(pattern[ch]);
                    if (ch + 1 >= pattern.length) continue block11;
                    switch (pattern[ch + 1]) {
                        case '!': 
                        case '^': {
                            buffer.append('^');
                            ++ch;
                            continue block11;
                        }
                        case ']': {
                            buffer.append(']');
                            ++ch;
                            continue block11;
                        }
                    }
                    continue block11;
                }
                case ']': {
                    inCharSet = false;
                    buffer.append(pattern[ch]);
                    continue block11;
                }
                case '\\': {
                    buffer.append('\\');
                    if (ch == pattern.length - 1) {
                        buffer.append('\\');
                        continue block11;
                    }
                    if (StringTool.isGlobMetaCharacter(pattern[ch + 1])) {
                        buffer.append(pattern[++ch]);
                        continue block11;
                    }
                    buffer.append('\\');
                    continue block11;
                }
                default: {
                    if (!inCharSet && StringTool.isPerl5MetaCharacter(pattern[ch])) {
                        buffer.append('\\');
                    }
                    buffer.append(pattern[ch]);
                }
            }
        }
        return buffer.toString();
    }

    public static boolean containsWildcardCharacters(String pattern) {
        for (int i = 0; i < pattern.length(); ++i) {
            if (GLOB_META_CHARACTERS.indexOf(pattern.charAt(i)) < 0) continue;
            return true;
        }
        return false;
    }

    private static boolean isPerl5MetaCharacter(char ch) {
        return PERL5_META_CHARACTERS.indexOf(ch) >= 0;
    }

    private static boolean isGlobMetaCharacter(char ch) {
        return GLOB_META_CHARACTERS.indexOf(ch) >= 0;
    }
}

