/*
 * Decompiled with CFR 0.152.
 */
package nl.sivworks.text;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import nl.sivworks.io.FileTool;
import nl.sivworks.text.BundleWrapper;
import nl.sivworks.text.DummyResourceBundle;
import nl.sivworks.text.SimpleString;
import nl.sivworks.text.TextLanguage;
import nl.sivworks.util.Environment;
import nl.sivworks.util.LocaleTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Text {
    private static final String KEY_INDICATOR = "|";
    private static final String BUNDLES_EMPTY = "bundles_empty";
    private static final boolean NORMALIZE = Environment.isWindows();
    private static final Logger logger = LoggerFactory.getLogger(Text.class);
    private static final List<BundleWrapper> bundleWrappers = new ArrayList<BundleWrapper>();
    private static final List<String> unknownKeys = new ArrayList<String>();
    private static final Map<Enum<?>, String> enumTexts = new HashMap();
    private static final Map<Enum<?>, String> englishEnumTexts = new HashMap();
    private static Locale locale = LocaleTool.getDefaultProgramLocale();

    private Text() {
    }

    public static boolean isEmpty() {
        return bundleWrappers.isEmpty();
    }

    public static Locale getLocale() {
        return locale;
    }

    public static synchronized void setLocale(Locale locale) {
        if (!Text.locale.equals(locale)) {
            Text.locale = locale;
            Text.reloadResources();
        }
    }

    public static synchronized void addResources(String ... baseNames) {
        for (String baseName : baseNames) {
            Text.addResource(baseName);
        }
    }

    public static synchronized void addResource(String baseName) {
        BundleWrapper wrapper = Text.getBundleWrapper(baseName);
        if (wrapper != null) {
            return;
        }
        ResourceBundle englishBundle = Text.loadBundle(baseName, LocaleTool.ENGLISH);
        if (englishBundle == null) {
            return;
        }
        ResourceBundle bundle = null;
        if (!locale.equals(LocaleTool.ENGLISH)) {
            bundle = Text.loadBundle(baseName, locale);
        }
        if (bundle == null) {
            bundle = new DummyResourceBundle();
        }
        bundleWrappers.add(0, new BundleWrapper(baseName, englishBundle, bundle));
    }

    public static synchronized String get(String key, Object ... arguments) {
        return Text.getFormattedText(Text.find(TextLanguage.CURRENT, key), arguments);
    }

    public static synchronized String getEnglish(String key, Object ... arguments) {
        return Text.getFormattedText(Text.find(TextLanguage.ENGLISH, key), arguments);
    }

    public static synchronized String get(Enum<?> value) {
        return Text.find(TextLanguage.CURRENT, value);
    }

    public static synchronized String getEnglish(Enum<?> value) {
        return Text.find(TextLanguage.ENGLISH, value);
    }

    private static String find(TextLanguage language, Enum<?> value) {
        String text;
        if (value == null) {
            return null;
        }
        Map<Enum<?>, String> map = enumTexts;
        if (language == TextLanguage.ENGLISH) {
            map = englishEnumTexts;
        }
        if ((text = map.get(value)) == null) {
            if (value instanceof SimpleString) {
                text = value.toString();
            } else {
                String key;
                String className = value.getClass().getCanonicalName();
                if (value.getClass().getPackage() != null) {
                    String packageName = value.getClass().getPackage().getName();
                    className = className.substring(packageName.length() + 1);
                }
                if ((text = Text.get(key = "Enum|" + className.replace('.', '|') + KEY_INDICATOR + value.name(), new Object[0])).equals(key)) {
                    text = value.toString();
                }
            }
            map.put(value, text);
        }
        return text;
    }

    private static String find(TextLanguage language, String key) {
        String text;
        if (key == null || !key.contains(KEY_INDICATOR)) {
            return key;
        }
        if (bundleWrappers.isEmpty()) {
            if (!unknownKeys.contains(BUNDLES_EMPTY)) {
                unknownKeys.add(BUNDLES_EMPTY);
                logger.warn("No text resources defined while searching for key " + key);
            }
            return key;
        }
        for (BundleWrapper wrapper : bundleWrappers) {
            text = wrapper.getString(language, key);
            if (text == null) continue;
            return text;
        }
        if (!language.equals((Object)TextLanguage.ENGLISH)) {
            for (BundleWrapper wrapper : bundleWrappers) {
                text = wrapper.getString(TextLanguage.ENGLISH, key);
                if (text == null) continue;
                return text;
            }
        }
        if (!unknownKeys.contains(key)) {
            unknownKeys.add(key);
            logger.warn("No resource found for key " + key);
        }
        return key;
    }

    private static String getFormattedText(String format, Object ... arguments) {
        if (format.length() == 0) {
            return "";
        }
        if (arguments.length == 0) {
            return format;
        }
        if (NORMALIZE) {
            return MessageFormat.format(format, Text.normalize(arguments));
        }
        return MessageFormat.format(format, arguments);
    }

    private static Object[] normalize(Object ... arguments) {
        Object[] displayArguments = new Object[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            Object object = arguments[i];
            if (object instanceof File) {
                File file = (File)object;
                displayArguments[i] = FileTool.getNormalizedPath(file);
                continue;
            }
            displayArguments[i] = arguments[i];
        }
        return displayArguments;
    }

    private static synchronized void reloadResources() {
        for (BundleWrapper wrapper : bundleWrappers) {
            ResourceBundle bundle = null;
            if (!locale.equals(LocaleTool.ENGLISH)) {
                bundle = Text.loadBundle(wrapper.getName(), locale);
            }
            if (bundle == null) {
                bundle = new DummyResourceBundle();
            }
            wrapper.setBundle(bundle);
        }
        enumTexts.clear();
    }

    private static ResourceBundle loadBundle(String baseName, Locale locale) {
        try {
            return ResourceBundle.getBundle(baseName, locale);
        }
        catch (MissingResourceException exc) {
            logger.error(exc.getMessage(), exc);
            return null;
        }
    }

    private static BundleWrapper getBundleWrapper(String name) {
        for (BundleWrapper wrapper : bundleWrappers) {
            if (!wrapper.getName().equals(name)) continue;
            return wrapper;
        }
        return null;
    }
}

