/*
 * Decompiled with CFR 0.152.
 */
package nl.sivworks.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import nl.sivworks.io.BytesOutputStream;
import nl.sivworks.io.UrlTool;
import nl.sivworks.text.DefaultTextHolder;
import nl.sivworks.text.TemplateTextHolder;
import nl.sivworks.text.TextHolder;
import nl.sivworks.util.ApplicationException;
import nl.sivworks.util.Cancellable;

public final class FileTool {
    private static final int COPY_BUFFER_SIZE = 2048;

    private FileTool() {
    }

    public static boolean isRecognized(File file) {
        Path path = file.toPath();
        for (Path root : FileSystems.getDefault().getRootDirectories()) {
            if (!path.startsWith(root)) continue;
            return true;
        }
        return false;
    }

    public static List<File> listFiles(File directory) {
        File[] files;
        if (directory.isDirectory() && (files = directory.listFiles()) != null) {
            return Arrays.asList(files);
        }
        return Collections.emptyList();
    }

    public static List<File> listFiles(File directory, FilenameFilter filter) {
        File[] files;
        if (directory.isDirectory() && (files = directory.listFiles(filter)) != null) {
            return Arrays.asList(files);
        }
        return Collections.emptyList();
    }

    public static boolean directoryIsParentOfFile(File directory, File file) {
        return !file.equals(directory) && file.toPath().startsWith(directory.toPath());
    }

    public static String getPathBetween(File directory, File file) throws IllegalArgumentException {
        return FileTool.getNormalizedPath(directory.toPath().relativize(file.toPath()).toString());
    }

    public static String getRelativePath(File directory, File file) {
        Path path = file.toPath();
        path = path.subpath(directory.toPath().getNameCount(), path.getNameCount());
        return path.toString();
    }

    public static String getRelativeNormalizedPath(File directory, File file) {
        Path path = file.toPath();
        path = path.subpath(directory.toPath().getNameCount(), path.getNameCount());
        return FileTool.getNormalizedPath(path.toString());
    }

    public static String getNormalizedPath(File file) {
        return FileTool.getNormalizedPath(file.getPath());
    }

    public static String getNormalizedPath(String path) {
        return path.replace("\\", "/");
    }

    public static File prepareBackupFile(File file, int maximum) {
        int i;
        if (maximum < 1) {
            maximum = 1;
        }
        String path = file.getPath();
        File backup = new File(path + ".#save#");
        ArrayList<File> list = new ArrayList<File>();
        while (list.size() < maximum + 10) {
            list.add(backup);
            backup = new File(path + ".#save-" + list.size() + "#");
        }
        for (i = list.size() - 1; i > maximum - 2; --i) {
            if (!((File)list.get(i)).exists()) continue;
            ((File)list.get(i)).delete();
        }
        for (i = maximum - 1; i > 0; --i) {
            File a = (File)list.get(i);
            File b = (File)list.get(i - 1);
            if (!b.exists()) continue;
            b.renameTo(a);
        }
        return (File)list.get(0);
    }

    public static String getFileChecksumSha256(File file) throws NoSuchAlgorithmException, IOException {
        return FileTool.getFileChecksum(MessageDigest.getInstance("SHA-256"), file);
    }

    public static String getFileChecksum(MessageDigest digest, File file) throws IOException {
        FileInputStream inputStream = new FileInputStream(file);
        byte[] byteArray = new byte[1024];
        int bytesCount = 0;
        while ((bytesCount = inputStream.read(byteArray)) != -1) {
            digest.update(byteArray, 0, bytesCount);
        }
        inputStream.close();
        byte[] bytes = digest.digest();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            builder.append(Integer.toString((bytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return builder.toString().toUpperCase();
    }

    public static long createChecksum(File file) throws IOException {
        try (CheckedInputStream checkedStream = new CheckedInputStream(new FileInputStream(file), new CRC32());){
            long l;
            try (BufferedInputStream inputStream = new BufferedInputStream(checkedStream);){
                while (inputStream.read() != -1) {
                }
                l = checkedStream.getChecksum().getValue();
            }
            return l;
        }
    }

    public static String getExtension(File file) {
        return FileTool.getExtension(file.getName());
    }

    public static String getExtension(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        return fileName.substring(index + 1);
    }

    public static String getFilenameWithoutExtension(File file) {
        return FileTool.getFilenameWithoutExtension(file.getName());
    }

    public static String getFilenameWithoutExtension(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return fileName;
        }
        return fileName.substring(0, index);
    }

    public static File getEnclosingFile(Class<?> aClass) {
        URL url = aClass.getProtectionDomain().getCodeSource().getLocation();
        return UrlTool.getFile(url);
    }

    public static File getTemporaryDirectory() {
        return new File(System.getProperty("java.io.tmpdir"));
    }

    public static boolean isEmptyDirectory(File file) {
        return file.isDirectory() && FileTool.listFiles(file).isEmpty();
    }

    public static boolean isNonEmptyDirectory(File file) {
        return file.isDirectory() && !FileTool.listFiles(file).isEmpty();
    }

    public static void createDirectory(File directory) throws ApplicationException {
        if (!directory.isDirectory()) {
            try {
                Files.createDirectories(directory.toPath(), new FileAttribute[0]);
            }
            catch (Exception exc) {
                TextHolder textHolder = new DefaultTextHolder("Msg|FailedToCreateDirectory", directory);
                if (exc instanceof AccessDeniedException) {
                    textHolder = new TemplateTextHolder("{0} ({1})", textHolder, new DefaultTextHolder("Msg|AccessDenied", new Object[0]));
                }
                throw new ApplicationException(textHolder, (Throwable)exc);
            }
        }
    }

    public static void copy(File source, File destination) throws ApplicationException, IOException {
        if (source.equals(destination)) {
            return;
        }
        if (!source.isFile()) {
            throw new ApplicationException(new DefaultTextHolder("Msg|NotAFile", source));
        }
        if (destination.isDirectory()) {
            throw new ApplicationException(new DefaultTextHolder("Msg|NotAFile", destination));
        }
        FileTool.createDirectory(destination.getParentFile());
        Files.copy(source.toPath(), destination.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public static void copy(InputStream sourceStream, OutputStream destinationStream) throws IOException {
        try (BufferedInputStream reader = new BufferedInputStream(sourceStream);
             BufferedOutputStream writer = new BufferedOutputStream(destinationStream);){
            int count;
            byte[] byteBuffer = new byte[2048];
            while ((count = reader.read(byteBuffer, 0, 2048)) != -1) {
                writer.write(byteBuffer, 0, count);
            }
            writer.flush();
        }
    }

    public static void copyToDirectory(File source, File destination) throws ApplicationException, IOException {
        if (!source.isFile()) {
            throw new ApplicationException(new DefaultTextHolder("Msg|NotAFile", source));
        }
        if (destination.isFile()) {
            throw new ApplicationException(new DefaultTextHolder("Msg|NotADirectory", destination));
        }
        File target = new File(destination, source.getName());
        if (source.equals(target)) {
            throw new ApplicationException(new DefaultTextHolder("Msg|CannotCopyFileToItself", new Object[0]));
        }
        FileTool.createDirectory(destination);
        Files.copy(source.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public static void copyDirectory(File source, File destination) throws ApplicationException, IOException {
        FileTool.copyDirectory(source, destination, new NoFilter());
    }

    public static void copyDirectory(File source, File destination, FileFilter filter) throws ApplicationException, IOException {
        if (!source.isDirectory()) {
            throw new ApplicationException(new DefaultTextHolder("Msg|NotADirectory", source));
        }
        if (destination.isFile()) {
            throw new ApplicationException(new DefaultTextHolder("Msg|NotADirectory", destination));
        }
        File newDestination = new File(destination, source.getName());
        FileTool.createDirectory(newDestination);
        FileTool.copyDirectoryContents(source, newDestination, filter);
    }

    public static void copyDirectoryContents(File source, File destination) throws ApplicationException, IOException {
        FileTool.copyDirectoryContents(source, destination, new NoFilter());
    }

    public static void copyDirectoryContents(File source, File destination, FileFilter filter) throws ApplicationException, IOException {
        if (!source.isDirectory()) {
            throw new ApplicationException(new DefaultTextHolder("Msg|NotADirectory", source));
        }
        if (!destination.isDirectory()) {
            throw new ApplicationException(new DefaultTextHolder("Msg|NotADirectory", destination));
        }
        for (File file : source.listFiles(filter)) {
            if (file.isDirectory()) {
                File newDestination = new File(destination, file.getName());
                FileTool.createDirectory(newDestination);
                FileTool.copyDirectoryContents(file, newDestination, filter);
                continue;
            }
            FileTool.copyToDirectory(file, destination);
        }
    }

    public static List<File> getFiles(File directory) {
        return FileTool.getFileObjects(directory, FileObject.FILES_ONLY);
    }

    public static List<File> getDirectories(File directory) {
        return FileTool.getFileObjects(directory, FileObject.DIRECTORIES_ONLY);
    }

    public static List<File> getFilesAndDirectories(File directory) {
        return FileTool.getFileObjects(directory, FileObject.FILES_AND_DIRECTORIES);
    }

    public static File renameFile(File file, String name) throws ApplicationException {
        File target = file.toPath().resolveSibling(name).toFile();
        return FileTool.renameFile(file, target);
    }

    public static File renameFile(File file, File target) throws ApplicationException {
        try {
            Path path = Files.move(file.toPath(), target.toPath(), new CopyOption[0]);
            return path.toFile();
        }
        catch (Exception exc) {
            TextHolder textHolder = new DefaultTextHolder("Msg|FailedToRenameFile", new Object[0]);
            if (exc instanceof AccessDeniedException) {
                textHolder = new TemplateTextHolder("{0} ({1})", textHolder, new DefaultTextHolder("Msg|AccessDenied", new Object[0]));
            }
            throw new ApplicationException(textHolder, (Throwable)exc);
        }
    }

    public static void removeFile(File file) throws ApplicationException {
        try {
            Files.delete(file.toPath());
        }
        catch (Exception exc) {
            TextHolder textHolder = new DefaultTextHolder("Msg|FailedToRemove", file);
            if (exc instanceof AccessDeniedException) {
                textHolder = new TemplateTextHolder("{0} ({1})", textHolder, new DefaultTextHolder("Msg|AccessDenied", new Object[0]));
            }
            throw new ApplicationException(textHolder, (Throwable)exc);
        }
    }

    public static void removeDirectory(File directory) throws ApplicationException {
        if (!directory.isDirectory()) {
            return;
        }
        FileTool.cleanUpDirectory(directory);
        FileTool.removeFile(directory);
    }

    public static boolean cleanUpDirectory(File directory) throws ApplicationException {
        return FileTool.cleanUpDirectory(directory, null);
    }

    public static boolean cleanUpDirectory(File directory, Cancellable cancellable) throws ApplicationException {
        try {
            return FileTool.handleCleanUpDirectory(directory, cancellable);
        }
        catch (Exception exc) {
            TextHolder textHolder = new DefaultTextHolder("Msg|FailedToCleanUpDirectory", directory);
            if (exc instanceof AccessDeniedException) {
                textHolder = new TemplateTextHolder("{0} ({1})", textHolder, new DefaultTextHolder("Msg|AccessDenied", new Object[0]));
            }
            throw new ApplicationException(textHolder, (Throwable)exc);
        }
    }

    private static boolean handleCleanUpDirectory(File directory, Cancellable cancellable) throws IOException {
        if (!directory.exists()) {
            return true;
        }
        if (!directory.isDirectory()) {
            return false;
        }
        if (cancellable != null && cancellable.isCancelled()) {
            return false;
        }
        for (File file : FileTool.listFiles(directory)) {
            if (cancellable != null && cancellable.isCancelled()) {
                return false;
            }
            if (file.isDirectory()) {
                FileTool.handleCleanUpDirectory(file, cancellable);
                if (cancellable != null && cancellable.isCancelled()) {
                    return false;
                }
            }
            Files.delete(file.toPath());
        }
        return FileTool.listFiles(directory).isEmpty();
    }

    public static String readText(InputStream inputStream, Charset charSet) throws IOException {
        if (charSet == null) {
            charSet = StandardCharsets.UTF_8;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, charSet));){
            int count;
            StringBuilder text = new StringBuilder();
            char[] buffer = new char[2048];
            while ((count = reader.read(buffer, 0, 2048)) != -1) {
                text.append(buffer, 0, count);
            }
            String string = text.toString();
            return string;
        }
    }

    public static List<String> readTextLines(File file, int maximumLines, Charset charSet) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(file.toPath(), charSet);){
            String buffer;
            ArrayList<String> lines = new ArrayList<String>();
            for (int counter = 0; counter < maximumLines && (buffer = reader.readLine()) != null; ++counter) {
                lines.add(buffer);
            }
            ArrayList<String> arrayList = lines;
            return arrayList;
        }
    }

    public static List<String> readTextLines(InputStream inputStream, int maximumLines, Charset charSet) throws IOException {
        if (charSet == null) {
            charSet = StandardCharsets.UTF_8;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, charSet));){
            String buffer;
            ArrayList<String> lines = new ArrayList<String>();
            for (int counter = 0; counter < maximumLines && (buffer = reader.readLine()) != null; ++counter) {
                lines.add(buffer);
            }
            ArrayList<String> arrayList = lines;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readByteStream(InputStream stream) throws IOException {
        BytesOutputStream out = null;
        try {
            int count;
            BufferedInputStream in = new BufferedInputStream(stream);
            out = new BytesOutputStream();
            byte[] buffer = new byte[2048];
            while ((count = in.read(buffer, 0, 2048)) != -1) {
                out.write(buffer, 0, count);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static boolean isCausedByAccessDenied(Exception exc) {
        Exception test = exc;
        while (test != null) {
            if (test instanceof AccessDeniedException) {
                return true;
            }
            if (test instanceof FileNotFoundException && test.getMessage().contains("Access is denied")) {
                return true;
            }
            Throwable throwable = test.getCause();
            if (throwable instanceof Exception) {
                Exception e;
                test = e = (Exception)throwable;
                continue;
            }
            test = null;
        }
        return false;
    }

    private static List<File> getFileObjects(File file, FileObject mode) {
        ArrayList<File> list = new ArrayList<File>();
        if (file.isFile() && (mode == FileObject.FILES_ONLY || mode == FileObject.FILES_AND_DIRECTORIES)) {
            list.add(file);
        } else if (file.isDirectory() && (mode == FileObject.DIRECTORIES_ONLY || mode == FileObject.FILES_AND_DIRECTORIES)) {
            list.add(file);
        }
        if (file.isDirectory()) {
            for (File f : FileTool.listFiles(file)) {
                list.addAll(FileTool.getFileObjects(f, mode));
            }
        }
        return list;
    }

    private static class NoFilter
    implements FileFilter {
        private NoFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return true;
        }
    }

    private static enum FileObject {
        FILES_ONLY,
        DIRECTORIES_ONLY,
        FILES_AND_DIRECTORIES;

    }
}

