/*
 * Decompiled with CFR 0.152.
 */
package nl.sivworks.installer.runtime.uninstall;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.sivworks.installer.InstallerConstants;
import nl.sivworks.installer.runtime.InstallerStatus;
import nl.sivworks.installer.util.InstallerException;
import nl.sivworks.installer.util.InstallerSystem;
import nl.sivworks.installer.util.InstallerTool;
import nl.sivworks.installer.util.Logger;
import nl.sivworks.io.FileTool;
import nl.sivworks.text.Text;
import nl.sivworks.util.Environment;
import nl.sivworks.util.LocaleTool;

public class Uninstaller {
    private static final String GO_FOR_IT = "goforit";
    private static final File TMP_DIRECTORY = InstallerSystem.getTemporaryDirectory();
    private static final Logger logger = InstallerSystem.createLogger("Uninstaller.log");
    private InstallerStatus status = InstallerStatus.PREPARING;

    public Uninstaller() {
        Text.setLocale(LocaleTool.getDefaultProgramLocale());
        Text.addResources(InstallerConstants.TEXT_RESOURCES);
    }

    private void execute() {
        logger.logMessage("Uninstaller started");
        try {
            Map<String, Object> uninstallData = this.getUninstallData();
            List installedFiles = (List)uninstallData.get("Installed Files");
            long time = (Long)uninstallData.get("Time");
            this.setStatus(InstallerStatus.BUSY);
            this.removeInstalledFiles(installedFiles, time);
            logger.logMessage("Uninstaller is finished");
            this.setStatus(InstallerStatus.FINISHED);
        }
        catch (Exception exc) {
            logger.logMessage(exc);
            logger.logMessage("Uninstaller is aborted");
            this.setStatus(InstallerStatus.ABORTED);
        }
    }

    public static void main(String[] arguments) {
        logger.logStart();
        boolean delegate = Environment.isWindows() && (arguments.length == 0 || !arguments[0].equals(GO_FOR_IT));
        File programFile = Uninstaller.getUninstallerFile();
        File dataFile = Uninstaller.getDataFile();
        if (Environment.isWindows() && !dataFile.exists()) {
            logger.logMessage("Data file not found: " + String.valueOf(dataFile));
            logger.logMessage("Uninstaller is aborted");
            Uninstaller.exit(InstallerStatus.ABORTED.getValue());
        }
        Uninstaller uninstaller = new Uninstaller();
        if (delegate) {
            logger.logMessage("Attempting to delegate...");
            try {
                if (!TMP_DIRECTORY.isDirectory()) {
                    TMP_DIRECTORY.mkdirs();
                }
                File targetProgramFile = new File(TMP_DIRECTORY, programFile.getName());
                File targetDataFile = new File(TMP_DIRECTORY, dataFile.getName());
                FileTool.copy(programFile, targetProgramFile);
                FileTool.copy(dataFile, targetDataFile);
                InstallerTool.runAsAdministrator(targetProgramFile, GO_FOR_IT);
                logger.logMessage("Delegated to " + String.valueOf(targetProgramFile));
                System.exit(0);
            }
            catch (Throwable exc) {
                logger.logMessage("Failed to delegate");
                logger.logMessage(exc);
            }
        }
        uninstaller.execute();
        if (uninstaller.getStatus() == InstallerStatus.FINISHED) {
            dataFile.deleteOnExit();
            programFile.deleteOnExit();
        }
        Uninstaller.exit(uninstaller.getStatus().getValue());
    }

    private InstallerStatus getStatus() {
        return this.status;
    }

    private void setStatus(InstallerStatus status) {
        this.status = status;
    }

    private Map<String, Object> getUninstallData() throws InstallerException {
        HashMap uninstallData = null;
        File dataFile = Uninstaller.getDataFile();
        try {
            InputStream stream = dataFile.exists() ? new FileInputStream(dataFile) : this.getClass().getResourceAsStream("/" + dataFile.getName());
            ObjectInputStream input = new ObjectInputStream(stream);
            uninstallData = (HashMap)input.readObject();
            input.close();
        }
        catch (Exception exc) {
            logger.logMessage(exc);
        }
        if (uninstallData == null) {
            throw new InstallerException("No uninstall data found");
        }
        return uninstallData;
    }

    private void removeInstalledFiles(List<File> installedFiles, long time) {
        logger.logMessage("Removing installed files");
        List<File> toDoList = installedFiles;
        ArrayList<File> remainingList = new ArrayList<File>();
        ArrayList<File> logList = new ArrayList<File>();
        boolean changed = true;
        while (changed) {
            changed = false;
            for (File file : toDoList) {
                if (!file.exists()) {
                    logger.logMessage("File does not exist: " + String.valueOf(file));
                    continue;
                }
                if (file.isDirectory() && file.list().length > 0) {
                    remainingList.add(file);
                    continue;
                }
                if (file.isDirectory() || file.lastModified() < time) {
                    try {
                        Files.delete(file.toPath());
                        changed = true;
                    }
                    catch (Exception exc) {
                        remainingList.add(file);
                        if (logList.contains(file)) continue;
                        logger.logMessage(exc.getMessage());
                        logList.add(file);
                    }
                    continue;
                }
                long difference = (file.lastModified() - time) / 1000L;
                logger.logMessage("Not allowed to remove file: " + String.valueOf(file) + " (time difference is: " + difference + " seconds)");
            }
            toDoList = remainingList;
            remainingList = new ArrayList();
        }
        for (File file : toDoList) {
            logger.logMessage("Failed to remove: " + String.valueOf(file));
        }
    }

    private static File getUninstallerFile() {
        return FileTool.getEnclosingFile(Uninstaller.class);
    }

    private static File getDataFile() {
        return new File(Uninstaller.getUninstallerFile().getParentFile(), InstallerSystem.getUninstallerDataFileName());
    }

    private static void exit(int status) {
        try {
            if (Environment.isWindows() && status != 0) {
                Thread.sleep(30000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.exit(status);
    }
}

