/*
 * Decompiled with CFR 0.152.
 */
package nl.sivworks.application.util;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.Scrollable;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import nl.sivworks.application.gui.components.ScrollablePanel;
import nl.sivworks.application.util.GuiFactory;

public final class GuiFactory {
    private static final Border RAISED_BORDER = new RaisedBorder();
    private static final Border RAISED_TABLE_BORDER = new RaisedTableBorder();
    private static final Border PANEL_BORDER = new EmptyBorder(5, 7, 5, 7);
    private static final Border ETCHED_PANEL_BORDER = new CompoundBorder(new EtchedBorder(), PANEL_BORDER);

    private GuiFactory() {
    }

    public static JScrollPane createScrollPane(Component component) {
        return GuiFactory.createScrollPane(component, 20, 30);
    }

    public static JScrollPane createScrollPane(Component component, Dimension dimension) {
        JScrollPane scrollPane = GuiFactory.createScrollPane(component, 20, 30);
        scrollPane.setPreferredSize(dimension);
        return scrollPane;
    }

    public static JScrollPane createScrollPane(Component component, int vsbPolicy, int hsbPolicy) {
        if (!(component instanceof Scrollable) && !(component instanceof Box)) {
            ScrollablePanel panel = new ScrollablePanel(vsbPolicy, hsbPolicy);
            panel.add(component);
            component = panel;
        }
        JScrollPane scrollPane = new JScrollPane(component, vsbPolicy, hsbPolicy);
        if (!(component instanceof JTable || component instanceof JList || component instanceof JTextArea || component instanceof Box)) {
            scrollPane.setBorder(BorderFactory.createEmptyBorder());
        }
        return scrollPane;
    }

    public static Border createRaisedBorder() {
        return RAISED_BORDER;
    }

    public static Border createRaisedTableBorder() {
        return RAISED_TABLE_BORDER;
    }

    public static Border createPanelBorder() {
        return PANEL_BORDER;
    }

    public static Border createEtchedPanelBorder() {
        return ETCHED_PANEL_BORDER;
    }
}

