/*
 * Decompiled with CFR 0.152.
 */
package nl.sivworks.util;

import java.util.HashMap;
import java.util.Map;

public final class ElapseTime {
    private static final Map<Thread, ThreadData> threadData = new HashMap<Thread, ThreadData>();
    private static final Map<String, Info> admin = new HashMap<String, Info>();

    private ElapseTime() {
    }

    public static void start(String key) {
        ThreadData data = threadData.get(Thread.currentThread());
        if (data == null) {
            data = new ThreadData();
            threadData.put(Thread.currentThread(), data);
        }
        if (key.equals(data.currentKey)) {
            ElapseTime.stop();
        }
        data.currentKey = key;
        data.previousElapseTime = data.startElapseTime = System.nanoTime() / 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop() {
        ThreadData data = threadData.get(Thread.currentThread());
        if (data != null && data.currentKey != null) {
            long currentTime = System.nanoTime() / 1000L;
            long diff = currentTime - data.startElapseTime;
            Map<String, Info> map = admin;
            synchronized (map) {
                Info info = admin.get(data.currentKey);
                if (info == null) {
                    info = new Info(diff, data.startElapseTime);
                    admin.put(data.currentKey, info);
                } else {
                    info.add(diff);
                }
                data.stringBuilder.setLength(0);
                data.stringBuilder.append("END INFO [").append(data.currentKey).append("]    Elapse: ");
                ElapseTime.printValue(data.stringBuilder, diff);
                data.stringBuilder.append("    Runs: ");
                data.stringBuilder.append(info.runs);
                data.stringBuilder.append("    Total: ");
                ElapseTime.printValue(data.stringBuilder, info.totalTime);
                data.stringBuilder.append("    Min: ");
                ElapseTime.printValue(data.stringBuilder, info.minimumTime);
                data.stringBuilder.append("    Avg: ");
                ElapseTime.printValue(data.stringBuilder, info.averageTime);
                data.stringBuilder.append("    Max: ");
                ElapseTime.printValue(data.stringBuilder, info.maximumTime);
                long callsPerSecond = 0L;
                if (info.runs > 1L) {
                    callsPerSecond = (long)((double)info.runs / ((double)(currentTime - info.startTime) / 1000000.0));
                }
                data.stringBuilder.append("    Calls/sec: ");
                data.stringBuilder.append(callsPerSecond);
                data.stringBuilder.append("    Threads: ");
                data.stringBuilder.append(threadData.size());
                data.stringBuilder.append("    Thread: ");
                data.stringBuilder.append(Thread.currentThread().getName());
            }
            System.out.println(data.stringBuilder);
            data.currentKey = null;
        }
    }

    public static void elapse(String string) {
        ThreadData data = threadData.get(Thread.currentThread());
        if (data != null) {
            long currentTime = System.nanoTime() / 1000L;
            data.stringBuilder.setLength(0);
            data.stringBuilder.append("Total: ");
            ElapseTime.printValue(data.stringBuilder, currentTime - data.startElapseTime);
            data.stringBuilder.append(" Elapse: ");
            ElapseTime.printValue(data.stringBuilder, currentTime - data.previousElapseTime);
            data.stringBuilder.append(" - ");
            data.stringBuilder.append(string);
            System.out.println(data.stringBuilder);
            data.previousElapseTime = System.nanoTime() / 1000L;
        }
    }

    private static void printValue(StringBuilder stringBuilder, long value) {
        if (value < 1000000L) {
            stringBuilder.append(value);
            stringBuilder.append(" us");
        } else {
            stringBuilder.append(value / 1000L);
            stringBuilder.append(" ms");
        }
    }

    private static final class ThreadData {
        final StringBuilder stringBuilder = new StringBuilder();
        String currentKey;
        long startElapseTime;
        long previousElapseTime;

        private ThreadData() {
        }
    }

    private static final class Info {
        final long startTime;
        long minimumTime;
        long totalTime;
        long averageTime;
        long maximumTime;
        long runs;

        public Info(long time, long startTime) {
            this.startTime = startTime;
            this.minimumTime = time;
            this.totalTime = time;
            this.maximumTime = time;
            this.averageTime = time;
            this.runs = 1L;
        }

        public void add(long time) {
            if (time < this.minimumTime) {
                this.minimumTime = time;
            }
            if (time > this.maximumTime) {
                this.maximumTime = time;
            }
            this.totalTime += time;
            ++this.runs;
            this.averageTime = this.totalTime / this.runs;
        }
    }
}

