/*
 * Decompiled with CFR 0.152.
 */
package nl.sivworks.installer.util;

import java.io.File;
import nl.sivworks.util.Environment;
import nl.sivworks.util.PackageEnvironment;
import nl.sivworks.util.ProductEnvironment;

public final class InstallerEnvironment
extends PackageEnvironment {
    private static final String PACKAGE = "Installer";
    private static final String DELIVER_TMP = "tmp";
    private static final String DELIVER_INSTALLER = "Installer";
    private static final String DELIVER_PACKAGE = "Package";
    private static final String INSTALL_BUILDER_LOG_FILE = "log/InstallBuilder.log";
    private static final String INSTALLER_DTD = "Installer.dtd";
    private static final String INSTALLER_WINDOWS_TEMPLATE = "InstallerLaunch.xml.template";
    private static final String UNINSTALLER_WINDOWS_TEMPLATE = "UninstallerLaunch.xml.template";
    private static final String LINUX_SCRIPT_TEMPLATE = "LinuxBase64.template";
    private static final String MAC_SCRIPT_TEMPLATE = "MacBase64.template";
    private static File targetBase;

    private InstallerEnvironment() {
    }

    public static void setTargetBaseDirectory(File targetBase) {
        InstallerEnvironment.targetBase = targetBase;
    }

    public static File getDeliverTemporaryDirectory() {
        return new File(targetBase, DELIVER_TMP);
    }

    public static File getDeliverInputDirectory() {
        return new File(targetBase, "Installer");
    }

    public static File getDeliverOutputDirectory() {
        return new File(targetBase, DELIVER_PACKAGE);
    }

    public static File getLaunch4jDirectory() {
        return new File(ProductEnvironment.getHome(), "Launch4j");
    }

    public static File getInstallBuilderLogFile() {
        return new File(InstallerEnvironment.getHome("Installer"), INSTALL_BUILDER_LOG_FILE);
    }

    public static File getInstallerDtd() {
        return new File(InstallerEnvironment.getConfigDirectory("Installer"), INSTALLER_DTD);
    }

    public static File getInstallerLaunchTemplateFile(Environment.OsGroup group) {
        return switch (group) {
            default -> throw new MatchException(null, null);
            case Environment.OsGroup.WINDOWS -> new File(InstallerEnvironment.getConfigDirectory("Installer"), INSTALLER_WINDOWS_TEMPLATE);
            case Environment.OsGroup.LINUX -> new File(InstallerEnvironment.getConfigDirectory("Installer"), LINUX_SCRIPT_TEMPLATE);
            case Environment.OsGroup.MAC -> new File(InstallerEnvironment.getConfigDirectory("Installer"), MAC_SCRIPT_TEMPLATE);
        };
    }

    public static File getUninstallerLaunchTemplateFile(Environment.OsGroup group) {
        return switch (group) {
            default -> throw new MatchException(null, null);
            case Environment.OsGroup.WINDOWS -> new File(InstallerEnvironment.getConfigDirectory("Installer"), UNINSTALLER_WINDOWS_TEMPLATE);
            case Environment.OsGroup.LINUX -> new File(InstallerEnvironment.getConfigDirectory("Installer"), LINUX_SCRIPT_TEMPLATE);
            case Environment.OsGroup.MAC -> new File(InstallerEnvironment.getConfigDirectory("Installer"), MAC_SCRIPT_TEMPLATE);
        };
    }
}

