/*
 * Decompiled with CFR 0.152.
 */
package nl.sivworks.installer.runtime;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import nl.sivworks.application.gui.components.TextPanel;
import nl.sivworks.text.SimpleTextHolder;

public class MessageDialog
extends JDialog {
    private static final int MINIMUM_WIDTH = 300;
    private final String[] options;
    private int selectedIndex = -1;
    private JButton defaultButton;

    public MessageDialog(Frame owner, String title, String message, String option) {
        this(owner, title, message, new String[]{option}, option, null);
    }

    public MessageDialog(Frame owner, String title, String message, String option, Icon icon) {
        this(owner, title, message, new String[]{option}, option, icon);
    }

    public MessageDialog(Frame owner, String title, String message, String[] options, String defaultOption) {
        this(owner, title, message, options, defaultOption, null);
    }

    public MessageDialog(Frame owner, String title, String message, String[] options, String defaultOption, Icon icon) {
        super(owner, title, true);
        this.options = options;
        this.add(new MessagePanel(this, message, options, defaultOption, icon));
    }

    @Override
    public void setVisible(boolean flag) {
        if (flag) {
            this.selectedIndex = -1;
            this.pack();
            Dimension mySize = this.getSize();
            if (mySize.width < 300) {
                mySize.width = 300;
                this.setSize(mySize);
            }
            if (this.defaultButton != null) {
                this.getRootPane().setDefaultButton(this.defaultButton);
            }
            this.centralize();
        }
        super.setVisible(flag);
    }

    public String getSelectedOption() {
        if (this.selectedIndex == -1) {
            return null;
        }
        return this.options[this.selectedIndex];
    }

    public int getResult() {
        return this.selectedIndex;
    }

    private void centralize() {
        int y;
        int x;
        Dimension mySize = this.getSize();
        Rectangle rectangle = this.getOwner().getBounds();
        Dimension screenSize = this.getToolkit().getScreenSize();
        if (!this.getOwner().isVisible() || rectangle.width == 0 || rectangle.height == 0) {
            x = (screenSize.width - mySize.width) / 2;
            y = (int)((double)screenSize.height - (double)screenSize.height / 1.618 - (double)(mySize.width / 2));
            if (y < rectangle.y + 20) {
                y = (screenSize.height - mySize.height) / 2;
            }
        } else {
            x = rectangle.x + (rectangle.width - mySize.width) / 2;
            y = (int)((double)(rectangle.y + rectangle.height) - (double)rectangle.height / 1.618 - (double)(mySize.height / 2));
            if (y < rectangle.y + 20) {
                y = rectangle.y + (rectangle.height - mySize.height) / 2;
            }
        }
        this.setDialogLocation(x, y);
    }

    private void setDialogLocation(int x, int y) {
        Dimension mySize = this.getSize();
        Dimension screenSize = this.getToolkit().getScreenSize();
        if (x < 0) {
            x = 0;
        } else if (x + mySize.width > screenSize.width) {
            x = screenSize.width - mySize.width;
        }
        if (y < 0) {
            y = 0;
        } else if (y + mySize.height > screenSize.height) {
            y = screenSize.height - mySize.height;
        }
        this.setLocation(x, y);
    }

    private static JPanel createButtonPanel(AbstractButton ... buttons) {
        JPanel panel = new JPanel(new MigLayout("insets 15 0 0 0, nogrid, gapx 15!", "[grow, center]"));
        for (AbstractButton button : buttons) {
            panel.add((Component)button, "sg");
        }
        return panel;
    }

    private class MessagePanel
    extends JPanel {
        final /* synthetic */ MessageDialog this$0;

        MessagePanel(MessageDialog messageDialog, String message, String[] options, String defaultOption, Icon icon) {
            MessageDialog messageDialog2 = messageDialog;
            Objects.requireNonNull(messageDialog2);
            this.this$0 = messageDialog2;
            JLabel iconContainer = icon == null ? new JLabel() : new JLabel(icon);
            AbstractButton[] buttons = new JButton[options.length];
            for (int i = 0; i < options.length; ++i) {
                buttons[i] = new JButton(options[i]);
                buttons[i].addActionListener(new ButtonHandler(messageDialog, i));
                if (!options[i].equals(defaultOption)) continue;
                messageDialog.defaultButton = buttons[i];
            }
            this.setLayout(new MigLayout("insets 20, gapx 15!, gapy 8!"));
            this.add(iconContainer);
            this.add((Component)new TextPanel(new SimpleTextHolder(message)), "growx, wrap");
            this.add((Component)MessageDialog.createButtonPanel(buttons), "spanx, growx, align center");
        }
    }

    private class ButtonHandler
    implements ActionListener {
        private final int buttonIndex;
        final /* synthetic */ MessageDialog this$0;

        ButtonHandler(MessageDialog messageDialog, int index) {
            MessageDialog messageDialog2 = messageDialog;
            Objects.requireNonNull(messageDialog2);
            this.this$0 = messageDialog2;
            this.buttonIndex = index;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.this$0.selectedIndex = this.buttonIndex;
            this.this$0.setVisible(false);
        }
    }
}

