/*
 * Decompiled with CFR 0.152.
 */
package nl.sivworks.installer.runtime;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import javax.swing.JFrame;
import nl.sivworks.installer.InstallerConstants;
import nl.sivworks.installer.data.Program;
import nl.sivworks.installer.runtime.ErrorDialog;
import nl.sivworks.installer.runtime.InstallerStatus;
import nl.sivworks.installer.runtime.MessageDialog;
import nl.sivworks.installer.runtime.PackageScreen;
import nl.sivworks.installer.runtime.QuestionDialog;
import nl.sivworks.installer.util.InstallerException;
import nl.sivworks.installer.util.InstallerSystem;
import nl.sivworks.installer.util.InstallerTool;
import nl.sivworks.installer.util.Logger;
import nl.sivworks.io.FileTool;
import nl.sivworks.text.Text;
import nl.sivworks.util.Environment;
import nl.sivworks.util.LocaleTool;

public final class Installer
extends JFrame {
    private static final String GO_FOR_IT = "goforit";
    private static final File TMP_DIRECTORY = InstallerSystem.getTemporaryDirectory();
    private static final Logger logger = InstallerSystem.createLogger("Installer.log");
    private final Map<String, Object> configuration;
    private final StringBuilder logBuffer = new StringBuilder();
    private InstallerStatus status;

    public Installer() throws InstallerException {
        this.configuration = this.readConfiguration();
        URL url = this.getClass().getResource("/ProductIcon.png");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(url));
        this.setTitle(Text.get("Title|Installer", new Object[0]));
        this.add(new PackageScreen(this));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowHandler(this));
        this.pack();
        this.setResizable(false);
    }

    @Override
    public void setVisible(boolean flag) {
        if (flag) {
            Dimension mySize = this.getSize();
            Dimension screenSize = this.getToolkit().getScreenSize();
            this.setLocation((screenSize.width - mySize.width) / 2, (screenSize.height - mySize.height) / 2);
        }
        super.setVisible(flag);
    }

    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    public InstallerStatus getStatus() {
        return this.status;
    }

    public void setStatus(InstallerStatus status) {
        this.status = status;
    }

    public void showMessage(String message) {
        new MessageDialog((Frame)this, this.getTitle(), message, Text.get("Button|Ok", new Object[0])).setVisible(true);
    }

    public void showError(String message) {
        new ErrorDialog((Frame)this, this.getTitle(), message, Text.get("Button|Ok", new Object[0])).setVisible(true);
    }

    public int showQuestion(String message, String[] options, String defaultOption) {
        QuestionDialog dialog = new QuestionDialog((Frame)this, this.getTitle(), message, options, defaultOption);
        dialog.setVisible(true);
        return dialog.getResult();
    }

    public void logError(Throwable exception) {
        this.logBuffer.append(Installer.getText(exception)).append("\n");
        logger.logMessage(exception);
    }

    public void logError(String message) {
        this.logBuffer.append(message).append("\n");
        logger.logMessage(message);
    }

    public void terminate() {
        if (this.getStatus() == InstallerStatus.ABORTED) {
            this.showError(Text.get("Msg|Aborted", new Object[0]));
        }
        if (this.logBuffer.length() > 0) {
            this.showError(this.logBuffer.toString());
        }
        logger.logMessage("Installer finished with status: " + String.valueOf((Object)this.getStatus()));
        this.setVisible(false);
        if (this.getStatus() == InstallerStatus.FINISHED) {
            this.launchProgram();
        }
        System.exit(0);
    }

    private void launchProgram() {
        Program program = (Program)this.configuration.get("Launch");
        if (program != null) {
            File home = (File)this.configuration.get("Home Directory");
            try {
                InstallerTool.runAsUser(new File(home, program.getPath()));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                try {
                    if (Environment.isWindows()) {
                        Thread.sleep(30000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private Map<String, Object> readConfiguration() throws InstallerException {
        try {
            InputStream in = this.getClass().getResource("/Install.info").openStream();
            ObjectInputStream input = new ObjectInputStream(in);
            Map configuration = (Map)input.readObject();
            input.close();
            return configuration;
        }
        catch (Exception exc) {
            throw new InstallerException(Text.get("Msg|ReadConfigurationError", new Object[0]), exc);
        }
    }

    public static void main(String[] arguments) {
        boolean delegate;
        System.setProperty("slf4j.provider", "org.slf4j.simple.SimpleServiceProvider");
        System.setProperty("slf4j.internal.verbosity", "WARN");
        logger.logStart();
        boolean bl = delegate = Environment.isWindows() && (arguments.length == 0 || !arguments[0].equals(GO_FOR_IT));
        if (delegate) {
            logger.logMessage("Attempting to delegate...");
            try {
                File programFile = FileTool.getEnclosingFile(Installer.class);
                logger.logMessage("Program file: " + programFile.getPath());
                InstallerTool.runAsAdministrator(programFile, GO_FOR_IT);
                logger.logMessage("Delegated to " + String.valueOf(programFile));
                System.exit(0);
            }
            catch (Throwable exc) {
                logger.logMessage("Failed to delegate");
                logger.logMessage(exc);
            }
        }
        logger.logMessage("Starting Installer...");
        try {
            Text.setLocale(LocaleTool.getDefaultProgramLocale());
            Text.addResources(InstallerConstants.TEXT_RESOURCES);
            Installer installer = new Installer();
            installer.setVisible(true);
        }
        catch (Throwable exc) {
            logger.logMessage("Fatal error in Installer");
            logger.logMessage(exc);
            try {
                if (Environment.isWindows()) {
                    Thread.sleep(10000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.exit(1);
        }
    }

    private static String getText(Throwable throwable) {
        Object text = "";
        while (throwable != null) {
            text = (String)text + Installer.getFormattedText(throwable);
            if ((throwable = throwable.getCause()) == null) continue;
            text = (String)text + "\nCaused by:\n\n";
        }
        return text;
    }

    private static String getFormattedText(Throwable throwable) {
        String text = throwable.toString() + "\n\n";
        for (StackTraceElement element : throwable.getStackTrace()) {
            text = text + element.toString() + "\n";
        }
        return text;
    }

    private class WindowHandler
    extends WindowAdapter {
        final /* synthetic */ Installer this$0;

        private WindowHandler(Installer installer) {
            Installer installer2 = installer;
            Objects.requireNonNull(installer2);
            this.this$0 = installer2;
        }

        @Override
        public void windowClosing(WindowEvent event) {
            if (this.this$0.getStatus() == InstallerStatus.BUSY) {
                String[] choices = new String[]{Text.get("Button|Yes", new Object[0]), Text.get("Button|No", new Object[0])};
                int result = this.this$0.showQuestion(Text.get("Msg|Quit", new Object[0]), choices, choices[1]);
                if (result != 0) {
                    return;
                }
            }
            this.this$0.terminate();
        }
    }
}

