/*
 * Decompiled with CFR 0.152.
 */
package nl.sivworks.installer.runtime;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import net.miginfocom.swing.MigLayout;
import nl.sivworks.application.gui.components.TextPanel;
import nl.sivworks.installer.data.InstallMap;
import nl.sivworks.installer.data.Program;
import nl.sivworks.installer.runtime.ActionPanel;
import nl.sivworks.installer.runtime.Installer;
import nl.sivworks.text.DefaultTextHolder;
import nl.sivworks.text.Text;
import nl.sivworks.util.Environment;

public final class FinishPanel
extends ActionPanel
implements ActionListener {
    private JCheckBox launchBox;
    private final Installer installer;
    private final Program program;

    public FinishPanel(Installer installer) {
        this.installer = installer;
        InstallMap map = (InstallMap)installer.getConfiguration().get("Install Map");
        this.program = Environment.isLinux() ? map.getProgram(Environment.getOsGroup()) : null;
        TextPanel textPanel = new TextPanel(new DefaultTextHolder("Msg|InstallationCompleted", new Object[0]));
        if (this.program != null) {
            this.launchBox = new JCheckBox(Text.get("Field|StartProgram", this.program.getName()));
            this.launchBox.addActionListener(this);
            this.setLayout(new MigLayout("insets 0, gapy 50!, flowy"));
            this.add(textPanel);
            this.add(this.launchBox);
        } else {
            this.setLayout(new BorderLayout());
            this.add((Component)textPanel, "Center");
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.launchBox.isSelected()) {
            this.installer.getConfiguration().put("Launch", this.program);
        } else {
            this.installer.getConfiguration().put("Launch", null);
        }
    }
}

