/*
 * Decompiled with CFR 0.152.
 */
package nl.sivworks.installer.data;

import java.io.Serializable;
import nl.sivworks.util.Environment;

public class BaseAction
implements Serializable {
    private static final String ALL = "all";
    private static final String WINDOWS = "windows";
    private static final String LINUX = "linux";
    private static final String MAC = "mac";
    private final String name;
    private String operatingSystem;
    private String permissions;
    private boolean convert;

    public BaseAction(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name is null");
        }
        this.name = name;
        this.operatingSystem = ALL;
        this.convert = false;
    }

    public String getName() {
        return this.name;
    }

    public void setOperatingSystem(String operatingSystem) {
        String group = operatingSystem.toLowerCase();
        if (!(group.equals(ALL) || group.contains(LINUX) || group.contains(WINDOWS) || group.contains(MAC))) {
            throw new IllegalArgumentException("Unknown operating system group specified: " + operatingSystem);
        }
        this.operatingSystem = group;
    }

    public boolean belongsOnOperatingSystem() {
        if (this.operatingSystem.equals(ALL)) {
            return true;
        }
        if (this.operatingSystem.contains(LINUX) && Environment.isLinux()) {
            return true;
        }
        if (this.operatingSystem.contains(WINDOWS) && Environment.isWindows()) {
            return true;
        }
        return this.operatingSystem.contains(MAC) && Environment.isMac();
    }

    public String getPermissions() {
        return this.permissions;
    }

    public void setPermissions(String permissions) {
        this.permissions = permissions;
    }

    public boolean isConvert() {
        return this.convert;
    }

    public void setConvert(boolean flag) {
        this.convert = flag;
    }
}

