/*
 * Decompiled with CFR 0.152.
 */
package nl.sivworks.util;

import java.util.ArrayList;
import java.util.List;
import nl.sivworks.util.CancelListener;

public class CancelProducer {
    private final List<CancelListener> listeners = new ArrayList<CancelListener>();

    public synchronized void addCancelListener(CancelListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("CancelListener is null");
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public synchronized void removeCancelListener(CancelListener listener) {
        this.listeners.remove(listener);
    }

    public synchronized void removeCancelListeners() {
        this.listeners.clear();
    }

    public synchronized List<CancelListener> getCancelListeners() {
        return new ArrayList<CancelListener>(this.listeners);
    }

    public boolean hasCancelListener() {
        return !this.listeners.isEmpty();
    }

    public void fireCancel() {
        for (CancelListener listener : this.getCancelListeners()) {
            listener.cancel();
        }
    }
}

