/*
 * Decompiled with CFR 0.152.
 */
package nl.sivworks.application.gui.components;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import nl.sivworks.application.gui.components.EPanel;
import nl.sivworks.text.TextHolder;

public class TitledPanel
extends EPanel {
    private static final EmptyBorder EMPTY_BORDER = new EmptyBorder(5, 5, 5, 5);
    private static final int EDGE_SPACE = 25;
    private TextHolder title;
    private TitledBorder outside = new TitledBorder(BorderFactory.createEtchedBorder(), null);

    public TitledPanel() {
        this(null, new BorderLayout());
    }

    public TitledPanel(LayoutManager layout) {
        this(null, layout);
    }

    public TitledPanel(TextHolder title) {
        this(title, new BorderLayout());
    }

    public TitledPanel(TextHolder title, LayoutManager layout) {
        super(layout);
        super.setBorder(new CompoundBorder(this.outside, EMPTY_BORDER));
        this.setTitle(title);
    }

    @Override
    public void updateUI() {
        if (this.outside != null && this.title != null) {
            this.outside.setTitle(this.title.toString());
        }
        super.updateUI();
    }

    protected TitledBorder getTitledBorder() {
        return this.outside;
    }

    public String getTitle() {
        if (this.outside != null) {
            return this.outside.getTitle();
        }
        return null;
    }

    public void setTitle(TextHolder title) {
        this.title = title;
        if (this.outside != null) {
            if (title == null) {
                this.outside.setTitle(null);
            } else {
                this.outside.setTitle(title.toString());
            }
            this.repaint();
        }
    }

    @Override
    public void setBorder(Border border) {
        this.outside = null;
        super.setBorder(border);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.outside != null && this.outside.getTitle() != null) {
            Dimension dimension = super.getPreferredSize();
            Dimension borderDimension = this.outside.getMinimumSize(this);
            return new Dimension(Math.max(dimension.width, borderDimension.width + 25), dimension.height);
        }
        return super.getPreferredSize();
    }
}

