/*
 * Decompiled with CFR 0.152.
 */
package nl.sivworks.util;

import nl.sivworks.util.StringTool;

public final class VersionTool {
    private static final int MINIMUM_VERSION_PARTS = 2;
    private static final int MAXIMUM_VERSION_PARTS = 4;
    private static final String DELIMITER = ".";

    private VersionTool() {
    }

    public static boolean isValid(String version) {
        if (version.startsWith(DELIMITER) || version.endsWith(DELIMITER)) {
            return false;
        }
        String[] numbers = StringTool.getTokens(version, DELIMITER);
        if (numbers.length < 2 || numbers.length > 4) {
            return false;
        }
        for (String number : numbers) {
            try {
                int value = Integer.parseInt(number);
                if (value >= 0) continue;
                return false;
            }
            catch (NumberFormatException exc) {
                return false;
            }
        }
        return true;
    }

    public static int compare(String v1, String v2) {
        String[] v1Parts = VersionTool.getParts(v1);
        String[] v2Parts = VersionTool.getParts(v2);
        for (int i = 0; i < 4; ++i) {
            int n2;
            String p1 = v1Parts[i];
            String p2 = v2Parts[i];
            int n1 = Integer.parseInt(p1);
            if (n1 > (n2 = Integer.parseInt(p2))) {
                return 1;
            }
            if (n1 >= n2) continue;
            return -1;
        }
        return 0;
    }

    public static String getBaseVersion(String version, int parts) {
        int[] numbers = VersionTool.getNumbers(version);
        Object result = "";
        for (int i = 0; i < parts; ++i) {
            result = i < numbers.length ? (String)result + Integer.toString(numbers[i]) : (String)result + "0";
            if (i >= parts - 1) continue;
            result = (String)result + DELIMITER;
        }
        return result;
    }

    private static int[] getNumbers(String version) {
        if (!VersionTool.isValid(version)) {
            throw new IllegalArgumentException("Invalid version format " + version);
        }
        String[] parts = StringTool.getTokens(version, DELIMITER);
        int[] numbers = new int[4];
        for (int i = 0; i < 4; ++i) {
            numbers[i] = i < parts.length ? Integer.parseInt(parts[i]) : 0;
        }
        return numbers;
    }

    private static String[] getParts(String version) {
        if (!VersionTool.isValid(version)) {
            throw new IllegalArgumentException("Invalid version format " + version);
        }
        String[] parts = StringTool.getTokens(version, DELIMITER);
        String[] numbers = new String[4];
        for (int i = 0; i < 4; ++i) {
            numbers[i] = i < parts.length ? parts[i] : "0";
        }
        return numbers;
    }
}

