/*
 * Decompiled with CFR 0.152.
 */
package nl.sivworks.util;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import nl.sivworks.io.StreamReader;
import nl.sivworks.util.Environment;

public class SystemCommand {
    private static final String WINDOWS_COMMAND = "cmd.exe /c \"{0}\"";
    private final String[] command;
    private List<String> outputLines;
    private List<String> errorLines;
    private int exitValue;
    private boolean executed = false;

    public SystemCommand(String ... command) {
        this.command = command;
    }

    public void execute() throws IOException, InterruptedException {
        Process process = new ProcessBuilder(this.command).start();
        StreamReader outputReader = new StreamReader("SystemCommand Output Reader", process.getInputStream());
        outputReader.start();
        StreamReader errorReader = new StreamReader("SystemCommand Error Reader", process.getErrorStream());
        errorReader.start();
        this.exitValue = process.waitFor();
        while (outputReader.isAlive() || errorReader.isAlive()) {
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {}
        }
        this.outputLines = outputReader.getLines();
        this.errorLines = errorReader.getLines();
        this.executed = true;
    }

    public List<String> getOutputs() {
        return this.outputLines;
    }

    public List<String> getErrors() {
        return this.errorLines;
    }

    public int getExitValue() {
        if (!this.executed) {
            throw new IllegalStateException("Command has not been executed");
        }
        return this.exitValue;
    }

    public static String getWrappedCommand(String command) {
        if (Environment.isWindows()) {
            return MessageFormat.format(WINDOWS_COMMAND, command);
        }
        return command;
    }
}

