/*
 * Decompiled with CFR 0.152.
 */
package nl.sivworks.util;

import java.io.File;
import java.lang.management.ManagementFactory;

public final class Environment {
    private static final String OS_NAME = System.getProperty("os.name");
    private static final boolean CASE_SENSITIVE = !new File("ABC").equals(new File("abc"));
    private static File userHome;
    private static int productPid;

    protected Environment() {
    }

    public static String getUserName() {
        return System.getProperty("user.name");
    }

    public static File getUserHome() {
        if (userHome == null) {
            userHome = new File(System.getProperty("user.home"));
        }
        return userHome;
    }

    public static int getPid() {
        if (productPid == -1) {
            String string = ManagementFactory.getRuntimeMXBean().getName();
            int index = string.indexOf(64);
            productPid = index == -1 ? 0 : Integer.parseInt(string.substring(0, index));
        }
        return productPid;
    }

    public static String getOsName() {
        return OS_NAME;
    }

    public static OsGroup getOsGroup() {
        if (OS_NAME.equalsIgnoreCase("unix") || OS_NAME.equalsIgnoreCase("linux")) {
            return OsGroup.LINUX;
        }
        if (OS_NAME.toLowerCase().startsWith("windows")) {
            return OsGroup.WINDOWS;
        }
        if (OS_NAME.toLowerCase().startsWith("mac")) {
            return OsGroup.MAC;
        }
        throw new IllegalArgumentException("Unknown operating system: " + OS_NAME);
    }

    public static boolean isLinux() {
        return Environment.getOsGroup() == OsGroup.LINUX;
    }

    public static boolean isWindows() {
        return Environment.getOsGroup() == OsGroup.WINDOWS;
    }

    public static boolean isMac() {
        return Environment.getOsGroup() == OsGroup.MAC;
    }

    public static boolean isCaseSensitive() {
        return CASE_SENSITIVE;
    }

    static {
        productPid = -1;
    }

    public static enum OsGroup {
        LINUX,
        WINDOWS,
        MAC;

    }
}

