/*
 * Decompiled with CFR 0.152.
 */
package nl.sivworks.installer.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import nl.sivworks.installer.util.InstallerException;
import nl.sivworks.installer.util.InstallerSystem;
import nl.sivworks.installer.util.NewLineConverter;
import nl.sivworks.io.FileTool;
import nl.sivworks.text.Text;
import nl.sivworks.util.ApplicationException;
import nl.sivworks.util.Environment;
import nl.sivworks.util.SystemCommand;

public final class InstallerTool {
    private static final String SINGLE_QUOTE = "'";

    private InstallerTool() {
    }

    public static void runAsAdministrator(File programFile, String argument) throws Throwable {
        if (!Environment.isWindows()) {
            throw new IllegalStateException("This is not a Windows system");
        }
        String program = SINGLE_QUOTE + programFile.getPath() + SINGLE_QUOTE;
        SystemCommand command = new SystemCommand("powershell.exe", "Start-Process", program, "-Argument", argument, "-verb", "RunAs");
        command.execute();
    }

    public static void runAsUser(File programFile) throws Throwable {
        if (Environment.isWindows()) {
            throw new IllegalStateException("This is not allowed on a Windows system");
        }
        String user = InstallerSystem.getSudoUser();
        SystemCommand command = user != null ? new SystemCommand("sudo", "-u", user, programFile.getPath()) : new SystemCommand(programFile.getPath());
        command.execute();
        if (command.getExitValue() != 0) {
            System.out.println("Problem starting: " + programFile.getPath());
            System.out.println("Command errors: " + String.valueOf(command.getErrors()));
        }
    }

    public static List<File> createDirectories(File directory) throws InstallerException {
        if (directory.isDirectory()) {
            return Collections.emptyList();
        }
        try {
            ArrayList<File> list = new ArrayList<File>();
            for (File test = directory; test != null && !test.isDirectory(); test = test.getParentFile()) {
                list.add(0, test);
            }
            FileTool.createDirectory(directory);
            return list;
        }
        catch (ApplicationException exc) {
            throw new InstallerException(exc.getMessage(), exc);
        }
    }

    public static String encodeToString(File file) throws IOException {
        String text = Base64.getEncoder().encodeToString(Files.readAllBytes(file.toPath()));
        int size = 76;
        String delimiter = "\r\n";
        int length = text.length();
        int total = length / size;
        int remainder = length % size;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < total; ++i) {
            builder.append(text.substring(i * size, (i + 1) * size)).append(delimiter);
        }
        if (remainder != 0) {
            builder.append(text.substring(total * size));
        }
        return builder.toString();
    }

    public static void convertFileFormat(File file) throws InstallerException {
        try {
            switch (Environment.getOsGroup()) {
                case WINDOWS: {
                    NewLineConverter.convert(file, NewLineConverter.Format.WINDOWS);
                    break;
                }
                case LINUX: {
                    NewLineConverter.convert(file, NewLineConverter.Format.LINUX);
                    break;
                }
                case MAC: {
                    NewLineConverter.convert(file, NewLineConverter.Format.MAC);
                }
            }
        }
        catch (Exception exc) {
            throw new InstallerException(Text.get("Msg|FailedToConvertFileFormat", file), exc);
        }
    }

    public static void setLinuxFilePermissions(File file, String mode) {
        if (!file.exists()) {
            return;
        }
        if (mode.length() < 2) {
            return;
        }
        boolean value = InstallerTool.isReadable(mode.charAt(0));
        boolean ownerOnly = value && !InstallerTool.isReadable(mode.charAt(1));
        file.setReadable(value, ownerOnly);
        value = InstallerTool.isWritable(mode.charAt(0));
        ownerOnly = value && !InstallerTool.isWritable(mode.charAt(1));
        file.setWritable(value, ownerOnly);
        value = InstallerTool.isExecutable(mode.charAt(0));
        ownerOnly = value && !InstallerTool.isExecutable(mode.charAt(1));
        file.setExecutable(value, ownerOnly);
    }

    private static boolean isReadable(char mode) {
        return (mode & 4) == 4;
    }

    private static boolean isWritable(char mode) {
        return (mode & 2) == 2;
    }

    private static boolean isExecutable(char mode) {
        return (mode & '\u0001') == 1;
    }
}

