/*
 * Decompiled with CFR 0.152.
 */
package nl.sivworks.io;

import java.io.File;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import nl.sivworks.event.EventListener;
import nl.sivworks.event.EventProducer;
import nl.sivworks.util.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileMonitor
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(FileMonitor.class);
    private static final int DEFAULT_SCAN_TIME = 2000;
    private final boolean caseSensitive;
    private final Map<Key, Info> fileMap;
    private final EventProducer eventProducer;
    private int scanTime;
    private boolean cancelled;

    public FileMonitor(boolean caseSensitive) {
        this.setName("File Monitor");
        this.setDaemon(true);
        this.caseSensitive = !Environment.isCaseSensitive() ? caseSensitive : false;
        this.fileMap = new ConcurrentHashMap<Key, Info>();
        this.eventProducer = new EventProducer();
        this.scanTime = 2000;
    }

    public int getScanTime() {
        return this.scanTime;
    }

    public void setScanTime(int scanTime) {
        this.scanTime = scanTime;
    }

    public synchronized void registerFile(File file) {
        if (file == null) {
            throw new IllegalArgumentException("File is null");
        }
        Key key = new Key(file, this.caseSensitive);
        Info info = this.fileMap.get(key);
        if (info == null) {
            long currentTime = -1L;
            if (FileMonitor.exists(file, this.caseSensitive)) {
                currentTime = file.lastModified();
            }
            this.fileMap.put(key, new Info(currentTime));
        } else {
            ++info.counter;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(this.getName() + " registered " + String.valueOf(file) + " (info is " + String.valueOf(this.fileMap.get(key)) + ")");
        }
    }

    public synchronized void unregisterFile(File file) {
        if (file == null) {
            return;
        }
        Key key = new Key(file, this.caseSensitive);
        Info info = this.fileMap.get(key);
        if (info != null) {
            --info.counter;
            if (info.counter < 1) {
                this.fileMap.remove(key);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug(this.getName() + " unregistered " + String.valueOf(file) + " (info is " + String.valueOf(this.fileMap.get(key)) + ")");
        }
    }

    public synchronized void unregisterAllFiles() {
        this.fileMap.clear();
    }

    public void cancel() {
        this.cancelled = true;
        if (logger.isDebugEnabled()) {
            logger.debug(this.getName() + " cancelled");
        }
    }

    public void addEventListener(EventListener listener) {
        this.eventProducer.addEventListener(listener);
    }

    public void removeEventListener(EventListener listener) {
        this.eventProducer.removeEventListener(listener);
    }

    public String getStatusReport() {
        StringBuilder builder = new StringBuilder();
        for (Key key : this.getKeys()) {
            builder.append(key.file).append(" - ").append(this.fileMap.get(key)).append("\n");
        }
        return builder.toString();
    }

    @Override
    public void run() {
        if (logger.isDebugEnabled()) {
            logger.debug(this.getName() + " started");
        }
        ArrayList<File> added = new ArrayList<File>();
        ArrayList<File> deleted = new ArrayList<File>();
        ArrayList<File> changed = new ArrayList<File>();
        while (!this.isInterrupted() && !this.cancelled) {
            for (Key key : this.getKeys()) {
                State state = this.getFileState(key);
                if (state == null) continue;
                if (logger.isDebugEnabled() && state != State.UNCHANGED) {
                    logger.debug(String.valueOf((Object)state) + " " + String.valueOf(key.file));
                }
                if (state == State.ADDED) {
                    added.add(key.file);
                } else if (state == State.DELETED) {
                    deleted.add(key.file);
                } else if (state == State.CHANGED) {
                    changed.add(key.file);
                }
                if (!this.cancelled) continue;
                break;
            }
            if (!(added.isEmpty() && deleted.isEmpty() && changed.isEmpty())) {
                this.eventProducer.notifyListeners((EventObject)new Event(this, added, deleted, changed));
            }
            added.clear();
            deleted.clear();
            changed.clear();
            try {
                FileMonitor.sleep(this.scanTime);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug(this.getName() + " stopped");
        }
    }

    private List<Key> getKeys() {
        return new ArrayList<Key>(this.fileMap.keySet());
    }

    private State getFileState(Key key) {
        Info info;
        long currentTime = -1L;
        if (FileMonitor.exists(key.file, this.caseSensitive)) {
            currentTime = key.file.lastModified();
        }
        if ((info = this.fileMap.get(key)) == null) {
            return null;
        }
        long referenceTime = info.time;
        if (referenceTime == currentTime) {
            return State.UNCHANGED;
        }
        info.time = currentTime;
        if (referenceTime == -1L) {
            return State.ADDED;
        }
        if (currentTime == -1L) {
            return State.DELETED;
        }
        return State.CHANGED;
    }

    private static boolean exists(File file, boolean caseSensitive) {
        if (!file.exists()) {
            return false;
        }
        try {
            if (caseSensitive) {
                return file.getPath().equals(file.getCanonicalPath());
            }
            return true;
        }
        catch (Exception exc) {
            return false;
        }
    }

    private static class Key {
        File file;
        String path;

        Key(File file, boolean strict) {
            this.file = file;
            if (strict) {
                this.path = file.getPath();
            }
        }

        public int hashCode() {
            if (this.path != null) {
                return this.path.hashCode();
            }
            return this.file.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof Key)) {
                return false;
            }
            Key key = (Key)object;
            if (this.path != null) {
                return this.path.equals(key.path);
            }
            return this.file.equals(key.file);
        }
    }

    private static class Info {
        long time;
        int counter;

        Info(long time) {
            this.time = time;
            this.counter = 1;
        }

        public String toString() {
            return "" + this.counter;
        }
    }

    public static enum State {
        ADDED,
        DELETED,
        CHANGED,
        UNCHANGED;

    }

    public static class Event
    extends EventObject {
        private final List<File> addedFiles;
        private final List<File> deletedFiles;
        private final List<File> changedFiles;

        public Event(FileMonitor source, List<File> addedFiles, List<File> deletedFiles, List<File> changedFiles) {
            super(source);
            this.addedFiles = addedFiles;
            this.deletedFiles = deletedFiles;
            this.changedFiles = changedFiles;
        }

        public boolean concerns(File file) {
            return this.addedFiles.contains(file) || this.deletedFiles.contains(file) || this.changedFiles.contains(file);
        }

        public List<File> getAddedFiles() {
            return this.addedFiles;
        }

        public List<File> getDeletedFiles() {
            return this.deletedFiles;
        }

        public List<File> getChangedFiles() {
            return this.changedFiles;
        }
    }
}

