/*
 * Decompiled with CFR 0.152.
 */
package nl.sivworks.installer.runtime;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import nl.sivworks.installer.runtime.ActionPanel;
import nl.sivworks.installer.runtime.DirectoryPanel;
import nl.sivworks.installer.runtime.ExecutePanel;
import nl.sivworks.installer.runtime.FinishPanel;
import nl.sivworks.installer.runtime.ImagePanel;
import nl.sivworks.installer.runtime.InstallWorker;
import nl.sivworks.installer.runtime.Installer;
import nl.sivworks.installer.runtime.InstallerStatus;
import nl.sivworks.installer.runtime.LicensePanel;
import nl.sivworks.installer.runtime.WelcomePanel;
import nl.sivworks.text.Text;
import nl.sivworks.util.ProgressListener;

public final class PackageScreen
extends JPanel {
    private final JPanel actionPanel;
    private final ButtonPanel buttonPanel;
    private final WelcomePanel welcomePanel;
    private final ExecutePanel executePanel;
    private final FinishPanel finishPanel;
    private final Installer installer;
    private final ActionPanel[] actionPanels;
    private int currentPanel = 0;

    public PackageScreen(Installer installer) {
        this.installer = installer;
        this.welcomePanel = new WelcomePanel(installer);
        LicensePanel licensePanel = new LicensePanel(installer);
        DirectoryPanel directoriesPanel = new DirectoryPanel(installer);
        this.executePanel = new ExecutePanel(installer);
        this.finishPanel = new FinishPanel(installer);
        this.actionPanels = new ActionPanel[]{this.welcomePanel, licensePanel, directoriesPanel, this.executePanel, this.finishPanel};
        Dimension dimension = licensePanel.getPreferredSize();
        dimension.setSize(dimension.width + 10, dimension.height + 20);
        this.actionPanel = new JPanel();
        this.actionPanel.setBorder(new EmptyBorder(10, 5, 10, 5));
        this.actionPanel.setPreferredSize(dimension);
        this.buttonPanel = new ButtonPanel(this);
        this.setBorder(null);
        this.setLayout(new BorderLayout());
        this.add((Component)new ImagePanel(), "North");
        this.add((Component)this.actionPanel, "Center");
        this.add((Component)this.buttonPanel, "South");
        this.showPanel(this.welcomePanel);
    }

    private void showPanel(ActionPanel panel) {
        this.showActionPanel(panel);
        if (panel instanceof ExecutePanel) {
            this.executePanel.displayInstallInfo();
        }
    }

    private void showActionPanel(ActionPanel panel) {
        this.actionPanel.removeAll();
        this.actionPanel.add(panel);
        this.actionPanel.revalidate();
        this.actionPanel.repaint();
        this.buttonPanel.previousButton.setEnabled(panel != this.welcomePanel && panel != this.finishPanel);
        this.buttonPanel.nextButton.setEnabled(panel != this.executePanel && panel != this.finishPanel);
        this.buttonPanel.installButton.setEnabled(panel == this.executePanel);
        this.buttonPanel.cancelButton.setEnabled(true);
        if (panel == this.finishPanel) {
            this.buttonPanel.cancelButton.setText(Text.get("Button|Close", new Object[0]));
        }
    }

    private void showNextScreen() {
        if (!this.actionPanels[this.currentPanel].isAllowedToContinue()) {
            return;
        }
        while (++this.currentPanel < this.actionPanels.length) {
            if (!this.actionPanels[this.currentPanel].isToBeDisplayed()) continue;
            this.showPanel(this.actionPanels[this.currentPanel]);
            return;
        }
    }

    private void showPreviousScreen() {
        while (--this.currentPanel >= 0) {
            if (!this.actionPanels[this.currentPanel].isToBeDisplayed()) continue;
            this.showPanel(this.actionPanels[this.currentPanel]);
            return;
        }
    }

    public void performInstallation() {
        this.buttonPanel.previousButton.setEnabled(false);
        this.buttonPanel.installButton.setEnabled(false);
        this.buttonPanel.cancelButton.setEnabled(false);
        ProgressHandler listener = new ProgressHandler(this, this.installer, this.executePanel.getProgressListener());
        new InstallWorker(this.installer, listener).install();
    }

    private class ButtonPanel
    extends JPanel
    implements ActionListener {
        final JButton previousButton;
        final JButton nextButton;
        final JButton installButton;
        final JButton cancelButton;
        final /* synthetic */ PackageScreen this$0;

        public ButtonPanel(PackageScreen packageScreen) {
            PackageScreen packageScreen2 = packageScreen;
            Objects.requireNonNull(packageScreen2);
            this.this$0 = packageScreen2;
            this.previousButton = new JButton("< " + Text.get("Button|Previous", new Object[0]));
            this.previousButton.addActionListener(this);
            this.nextButton = new JButton(Text.get("Button|Next", new Object[0]) + " >");
            this.nextButton.addActionListener(this);
            this.installButton = new JButton(Text.get("Button|Install", new Object[0]));
            this.installButton.addActionListener(this);
            this.cancelButton = new JButton(Text.get("Button|Cancel", new Object[0]));
            this.cancelButton.addActionListener(this);
            this.setBorder(new EmptyBorder(20, 20, 20, 20));
            this.setLayout(new MigLayout("insets 0, nogrid, gapx 20!", "[grow, center]"));
            this.add((Component)this.previousButton, "sg");
            this.add((Component)this.nextButton, "sg, gapafter 40");
            this.add((Component)this.installButton, "sg");
            this.add((Component)this.cancelButton, "sg");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (this.this$0.installer.getStatus() == InstallerStatus.ABORTED) {
                this.this$0.installer.terminate();
            } else if (event.getSource() == this.previousButton) {
                this.this$0.showPreviousScreen();
            } else if (event.getSource() == this.nextButton) {
                this.this$0.showNextScreen();
            } else if (event.getSource() == this.installButton) {
                this.this$0.performInstallation();
            } else if (event.getSource() == this.cancelButton) {
                if (this.this$0.installer.getStatus() != InstallerStatus.FINISHED) {
                    this.this$0.installer.setStatus(InstallerStatus.CANCELLED);
                }
                this.this$0.installer.terminate();
            }
        }
    }

    private class ProgressHandler
    implements ProgressListener {
        private final Installer installer;
        private final ProgressListener progressListener;
        final /* synthetic */ PackageScreen this$0;

        ProgressHandler(PackageScreen packageScreen, Installer installer, ProgressListener progressListener) {
            PackageScreen packageScreen2 = packageScreen;
            Objects.requireNonNull(packageScreen2);
            this.this$0 = packageScreen2;
            this.installer = installer;
            this.progressListener = progressListener;
        }

        @Override
        public void start(int minimum, int maximum) {
            this.progressListener.start(minimum, maximum);
            this.installer.setStatus(InstallerStatus.BUSY);
        }

        @Override
        public void progress(int count, Object object) {
            this.progressListener.progress(count, object);
        }

        @Override
        public void done(int count, Object object) {
        }

        @Override
        public void ready() {
            this.progressListener.ready();
            this.installer.setStatus(InstallerStatus.FINISHED);
            this.this$0.showNextScreen();
        }

        @Override
        public void failed(Throwable cause) {
            this.progressListener.failed(cause);
            this.installer.showError(cause.getMessage());
            this.installer.setStatus(InstallerStatus.ABORTED);
            this.installer.terminate();
        }
    }
}

