/*
 * Decompiled with CFR 0.152.
 */
package nl.sivworks.installer.runtime;

import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import net.miginfocom.swing.MigLayout;
import nl.sivworks.installer.data.InstallMap;
import nl.sivworks.installer.runtime.ActionPanel;
import nl.sivworks.installer.runtime.Installer;
import nl.sivworks.installer.runtime.InstallerStatus;
import nl.sivworks.text.Text;
import nl.sivworks.util.ProgressListener;

public final class ExecutePanel
extends ActionPanel {
    private final JLabel folderLabel;
    private final Installer installer;
    private final ProgressHandler progressHandler;

    public ExecutePanel(Installer installer) {
        this.installer = installer;
        InstallMap map = (InstallMap)installer.getConfiguration().get("Install Map");
        this.folderLabel = new JLabel("-");
        JLabel progressField = new JLabel();
        JProgressBar progressBar = new JProgressBar();
        progressBar.setStringPainted(true);
        progressBar.setPreferredSize(new Dimension(300, progressBar.getPreferredSize().height));
        progressBar.setVisible(false);
        this.setLayout(new MigLayout("insets 0, gapy 10!, flowy"));
        this.add(new JLabel(Text.get("Msg|ExecuteInstall", map.getPackageName())));
        this.add(this.folderLabel);
        this.add(new JLabel(Text.get("Msg|PressInstallButton", new Object[0])));
        this.add((Component)progressField, "gaptop 20");
        this.add(progressBar);
        this.progressHandler = new ProgressHandler(progressField, progressBar);
    }

    @Override
    public boolean isAllowedToContinue() {
        return this.installer.getStatus() == InstallerStatus.FINISHED || this.installer.getStatus() == InstallerStatus.ABORTED;
    }

    public void displayInstallInfo() {
        File home = (File)this.installer.getConfiguration().get("Home Directory");
        this.folderLabel.setText(home.getPath());
        this.folderLabel.revalidate();
        this.folderLabel.repaint();
    }

    public ProgressListener getProgressListener() {
        return this.progressHandler;
    }

    private static class ProgressHandler
    implements ProgressListener {
        private final JLabel progressField;
        private final JProgressBar progressBar;

        ProgressHandler(JLabel progressField, JProgressBar progressBar) {
            this.progressField = progressField;
            this.progressBar = progressBar;
        }

        @Override
        public void start(int minimum, int maximum) {
            boolean indeterminate = minimum == maximum;
            this.progressBar.setIndeterminate(indeterminate);
            this.progressBar.setStringPainted(!indeterminate);
            this.progressBar.setMinimum(minimum);
            this.progressBar.setMaximum(maximum);
            this.progressBar.setValue(minimum);
            this.progressBar.setVisible(true);
            this.progressField.setVisible(true);
        }

        @Override
        public void progress(int count, Object object) {
            if (count > 0) {
                this.progressBar.setValue(count);
            }
            if (object != null) {
                this.progressField.setText(object.toString());
                this.progressField.revalidate();
                this.progressField.repaint();
            }
        }

        @Override
        public void done(int count, Object object) {
        }

        @Override
        public void ready() {
            this.progressBar.setValue(this.progressBar.getMaximum());
            this.progressField.setText(" ");
            this.progressField.revalidate();
            this.progressField.repaint();
        }

        @Override
        public void failed(Throwable cause) {
        }
    }
}

