/*
 * Decompiled with CFR 0.152.
 */
package nl.sivworks.installer.runtime;

import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingWorker;
import nl.sivworks.installer.data.InstallMap;
import nl.sivworks.installer.data.PackageModule;
import nl.sivworks.util.Environment;
import nl.sivworks.util.SystemCommand;

public final class CheckWorker
extends SwingWorker<List<PackageModule>, Object> {
    private final InstallMap map;

    CheckWorker(InstallMap map) {
        this.map = map;
    }

    @Override
    protected List<PackageModule> doInBackground() {
        if (Environment.isWindows()) {
            return this.runningOnWindows(this.map.getPreInstallCheck().getModules());
        }
        return this.runningOnUnix(this.map.getPreInstallCheck().getModules());
    }

    @Override
    protected void done() {
    }

    private List<PackageModule> runningOnWindows(List<PackageModule> modules) {
        ArrayList<PackageModule> list = new ArrayList<PackageModule>();
        SystemCommand command = new SystemCommand("tasklist", "/V");
        try {
            command.execute();
            for (String string : command.getOutputs()) {
                if (!string.contains("javaw.exe")) continue;
                for (PackageModule module : modules) {
                    if (!string.contains(module.getTitle())) continue;
                    list.add(module);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    private List<PackageModule> runningOnUnix(List<PackageModule> modules) {
        ArrayList<PackageModule> list = new ArrayList<PackageModule>();
        SystemCommand command = new SystemCommand("ps", "-ef");
        try {
            command.execute();
            for (String string : command.getOutputs()) {
                if (!string.contains("java")) continue;
                for (PackageModule module : modules) {
                    if (!string.contains(module.getName() + "Main")) continue;
                    list.add(module);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }
}

