/*
 * Decompiled with CFR 0.152.
 */
package nl.sivworks.application.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import nl.sivworks.application.ActionManager;
import nl.sivworks.application.Application;
import nl.sivworks.application.gui.components.ToolbarButton;
import nl.sivworks.application.gui.dialogs.EDialog;
import nl.sivworks.application.gui.table.ETable;
import nl.sivworks.application.util.SettingsHolder;

public final class GuiTool {
    private static final int DEFAULT_MODIFIER_DOWN = Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();
    private static final int ALT_DOWN = 512;
    private static final int SHIFT_DOWN = 64;
    private static final int[] CONDITIONS = new int[]{2, 0, 1};

    private GuiTool() {
    }

    public static KeyStroke getDefaultCutKeyStroke() {
        return KeyStroke.getKeyStroke(88, DEFAULT_MODIFIER_DOWN);
    }

    public static KeyStroke getDefaultCopyKeyStroke() {
        return KeyStroke.getKeyStroke(67, DEFAULT_MODIFIER_DOWN);
    }

    public static KeyStroke getDefaultPasteKeyStroke() {
        return KeyStroke.getKeyStroke(86, DEFAULT_MODIFIER_DOWN);
    }

    public static KeyStroke getDefaultFindKeyStroke() {
        return KeyStroke.getKeyStroke(70, DEFAULT_MODIFIER_DOWN);
    }

    public static KeyStroke getDefaultFindNextKeyStroke() {
        return KeyStroke.getKeyStroke(114, 0);
    }

    public static KeyStroke getDefaultFindPreviousKeyStroke() {
        return KeyStroke.getKeyStroke(114, 64);
    }

    public static KeyStroke getDefaultUndoKeyStroke() {
        return KeyStroke.getKeyStroke(90, DEFAULT_MODIFIER_DOWN);
    }

    public static KeyStroke getDefaultRedoKeyStroke() {
        return KeyStroke.getKeyStroke(89, DEFAULT_MODIFIER_DOWN);
    }

    public static KeyStroke getDefaultSaveKeyStroke() {
        return KeyStroke.getKeyStroke(83, DEFAULT_MODIFIER_DOWN);
    }

    public static KeyStroke getDefaultOpenKeyStroke() {
        return KeyStroke.getKeyStroke(79, DEFAULT_MODIFIER_DOWN);
    }

    public static KeyStroke getDefaultCloseKeyStroke() {
        return KeyStroke.getKeyStroke(87, DEFAULT_MODIFIER_DOWN);
    }

    public static KeyStroke getDefaultQuitKeyStroke() {
        return KeyStroke.getKeyStroke(81, DEFAULT_MODIFIER_DOWN);
    }

    public static KeyStroke getDefaultSelectAllKeyStroke() {
        return KeyStroke.getKeyStroke(65, DEFAULT_MODIFIER_DOWN);
    }

    public static KeyStroke getDefaultClearKeyStroke() {
        return KeyStroke.getKeyStroke(127, DEFAULT_MODIFIER_DOWN);
    }

    public static KeyStroke getDefaultNewKeyStroke() {
        return KeyStroke.getKeyStroke(78, DEFAULT_MODIFIER_DOWN);
    }

    public static KeyStroke getDefaultInsertSpecialKeyStroke() {
        return KeyStroke.getKeyStroke(73, DEFAULT_MODIFIER_DOWN);
    }

    public static KeyStroke getDefaultSaveAllKeyStroke() {
        return KeyStroke.getKeyStroke(83, DEFAULT_MODIFIER_DOWN | 0x40);
    }

    public static KeyStroke getDefaultSaveAsKeyStroke() {
        return KeyStroke.getKeyStroke(83, DEFAULT_MODIFIER_DOWN | 0x200);
    }

    public static KeyStroke getDefaultCloseAllKeyStroke() {
        return KeyStroke.getKeyStroke(87, DEFAULT_MODIFIER_DOWN | 0x40);
    }

    public static KeyStroke getDefaultHelpKeyStroke() {
        return KeyStroke.getKeyStroke(112, 0);
    }

    public static String getUserKeyStrokeText(KeyStroke keyStroke) {
        if (keyStroke == null) {
            return null;
        }
        String modifierText = InputEvent.getModifiersExText(keyStroke.getModifiers());
        String keyText = KeyEvent.getKeyText(keyStroke.getKeyCode());
        if (modifierText.length() > 0) {
            return modifierText + " " + keyText;
        }
        return keyText;
    }

    public static Set<KeyStroke> collectKeyStrokes(Container container) {
        HashSet<KeyStroke> set = new HashSet<KeyStroke>();
        for (Component c : container.getComponents()) {
            if (c instanceof JComponent) {
                JComponent jc = (JComponent)c;
                for (int i : CONDITIONS) {
                    InputMap inputMap = jc.getInputMap(i);
                    if (inputMap == null || inputMap.allKeys() == null) continue;
                    set.addAll(Arrays.asList(inputMap.allKeys()));
                }
            }
            if (!(c instanceof Container)) continue;
            Container ctr = (Container)c;
            set.addAll(GuiTool.collectKeyStrokes(ctr));
        }
        return set;
    }

    public static void updateKeyBindings(Application application, String command, KeyStroke keyStroke) {
        GuiTool.updateKeyBindings(application.getRootPane(), command, keyStroke);
        SwingUtilities.updateComponentTreeUI((Component)application);
        for (Window window : application.getOwnedWindows()) {
            if (!(window instanceof EDialog)) continue;
            EDialog dialog = (EDialog)window;
            GuiTool.updateKeyBindings(dialog.getRootPane(), command, keyStroke);
            SwingUtilities.updateComponentTreeUI((Component)dialog);
        }
    }

    private static void updateKeyBindings(JComponent component, String command, KeyStroke keyStroke) {
        if (component.getActionMap() != null && component.getActionMap().get(command) != null) {
            block0: for (int i : CONDITIONS) {
                InputMap inputMap = component.getInputMap(i);
                if (inputMap == null || inputMap.keys() == null) continue;
                for (KeyStroke ks : inputMap.keys()) {
                    Object binding = inputMap.get(ks);
                    if (!binding.toString().equals(command)) continue;
                    inputMap.remove(ks);
                    inputMap.put(keyStroke, command);
                    continue block0;
                }
            }
        }
        if (component instanceof ToolbarButton) {
            Object key;
            ToolbarButton toolbarButton = (ToolbarButton)component;
            Action action = toolbarButton.getAction();
            if (action != null && command.equals(key = action.getValue("ActionCommandKey"))) {
                action.putValue("AcceleratorKey", keyStroke);
                toolbarButton.updateUI();
            }
            return;
        }
        for (Component c : component.getComponents()) {
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            GuiTool.updateKeyBindings(jc, command, keyStroke);
        }
    }

    public static boolean isDoubleClickWithLeftMouseButton(MouseEvent event) {
        return event.getID() == 502 && event.getClickCount() == 2 && event.getButton() == 1;
    }

    public static void handleRecordSelection(ETable<?> table, MouseEvent event) {
        if (!event.isPopupTrigger() || !table.isEnabled()) {
            return;
        }
        int row = table.rowAtPoint(event.getPoint());
        if (row == -1) {
            return;
        }
        boolean selected = false;
        for (int r : table.getSelectedRows()) {
            if (r != row) continue;
            selected = true;
            break;
        }
        if (!selected) {
            table.getSelectionModel().setSelectionInterval(row, row);
        }
    }

    public static void storeSettings(Component component) {
        if (component instanceof SettingsHolder) {
            SettingsHolder holder = (SettingsHolder)component;
            holder.storeSettings();
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            for (Component child : container.getComponents()) {
                GuiTool.storeSettings(child);
            }
        }
    }

    public static Action getAction(ActionEvent event) {
        Object object = event.getSource();
        if (object instanceof AbstractButton) {
            AbstractButton button = (AbstractButton)object;
            return button.getAction();
        }
        object = event.getSource();
        if (object instanceof ActionManager) {
            ActionManager manager = (ActionManager)object;
            return manager.getAction(event.getActionCommand());
        }
        return null;
    }
}

