/*
 * Decompiled with CFR 0.152.
 */
package nl.sivworks.application.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFormattedTextField;
import javax.swing.JList;
import javax.swing.JPasswordField;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import nl.sivworks.application.data.SharedSettings;

public final class ComponentManager {
    private static final String[] SWING_TEXT_KEYS = new String[]{"FileChooser.lookInLabelText", "FileChooser.saveInLabelText", "FileChooser.fileNameLabelText", "FileChooser.folderNameLabelText", "FileChooser.filesOfTypeLabelText", "FileChooser.openButtonText", "FileChooser.cancelButtonText", "FileChooser.saveButtonText", "FileChooser.upFolderToolTipText", "FileChooser.newFolderToolTipText", "FileChooser.listViewButtonToolTipText", "FileChooser.detailsViewButtonToolTipText", "FileChooser.acceptAllFileFilterText", "ColorChooser.swatchesNameText", "ColorChooser.swatchesRecentText", "ColorChooser.previewText", "ColorChooser.sampleText", "ColorChooser.hsvHueText", "ColorChooser.hsvSaturationText", "ColorChooser.hsvValueText", "ColorChooser.hsvTransparencyText", "ColorChooser.hslHueText", "ColorChooser.hslSaturationText", "ColorChooser.hslLightnessText", "ColorChooser.hslTransparencyText", "ColorChooser.rgbBlueText", "ColorChooser.rgbGreenText", "ColorChooser.rgbRedText", "ColorChooser.rgbAlphaText", "ColorChooser.rgbHexCodeText", "ColorChooser.cmykCyanText", "ColorChooser.cmykMagentaText", "ColorChooser.cmykYellowText", "ColorChooser.cmykBlackText", "ColorChooser.cmykAlphaText"};
    private static final String[] MNEMONIC_KEYS = new String[]{"FileChooser.openButtonMnemonic", "FileChooser.cancelButtonMnemonic", "FileChooser.saveButtonMnemonic", "FileChooser.lookInLabelMnemonic", "FileChooser.saveInLabelMnemonic", "FileChooser.fileNameLabelMnemonic", "FileChooser.folderNameLabelMnemonic", "FileChooser.filesOfTypeLabelMnemonic", "ColorChooser.swatchesMnemonic", "ColorChooser.hsbMnemonic", "ColorChooser.hsvMnemonic", "ColorChooser.hslMnemonic", "ColorChooser.cmykMnemonic", "ColorChooser.rgbMnemonic", "ColorChooser.resetMnemonic", "ColorChooser.rgbBlueMnemonic", "ColorChooser.rgbGreenMnemonic", "ColorChooser.rgbRedMnemonic", "ColorChooser.rgbHexCodeMnemonic"};

    private ComponentManager() {
    }

    public static void initialize() {
        UIManager.put("FileChooser.openButtonToolTipText", "");
        UIManager.put("FileChooser.cancelButtonToolTipText", "");
        UIManager.put("FileChooser.saveButtonToolTipText", "");
        for (String key : MNEMONIC_KEYS) {
            UIManager.put(key, 0);
        }
        UIManager.put("TextField.selectAllOnFocus", SharedSettings.getInstance().isSelectAllOnFocusEnabled());
        UIManager.put("Table.background", UIManager.getColor("Label.background"));
        UIManager.put("Table.selectionBackground", new Color(218, 228, 240));
        ComponentManager.updateSwingText(SharedSettings.getInstance().getLocale());
    }

    public static void updateSwingText(Locale locale) {
        if (locale.getLanguage().equals("nl")) {
            UIManager.put("FileChooser.lookInLabelText", "Kijk in:");
            UIManager.put("FileChooser.saveInLabelText", "Opslaan in:");
            UIManager.put("FileChooser.fileNameLabelText", "Bestandsnaam:");
            UIManager.put("FileChooser.folderNameLabelText", "Map:");
            UIManager.put("FileChooser.filesOfTypeLabelText", "Bestanden van type:");
            UIManager.put("FileChooser.openButtonText", "Openen");
            UIManager.put("FileChooser.cancelButtonText", "Annuleren");
            UIManager.put("FileChooser.saveButtonText", "Opslaan");
            UIManager.put("FileChooser.upFolderToolTipText", "Bovenliggende map");
            UIManager.put("FileChooser.newFolderToolTipText", "Nieuwe map maken");
            UIManager.put("FileChooser.listViewButtonToolTipText", "Lijst");
            UIManager.put("FileChooser.detailsViewButtonToolTipText", "Details");
            UIManager.put("FileChooser.acceptAllFileFilterText", "Alle bestanden");
            UIManager.put("ColorChooser.swatchesNameText", "Kleurstalen");
            UIManager.put("ColorChooser.swatchesRecentText", "Recent:");
            UIManager.put("ColorChooser.previewText", "Voorvertoning");
            UIManager.put("ColorChooser.sampleText", "Voorbeeld Tekst Voorbeeld Tekst");
            UIManager.put("ColorChooser.rgbBlueText", "Blauw");
            UIManager.put("ColorChooser.rgbGreenText", "Groen");
            UIManager.put("ColorChooser.rgbRedText", "Rood");
            UIManager.put("ColorChooser.rgbAlphaText", "Alfa");
        } else {
            for (String key : SWING_TEXT_KEYS) {
                UIManager.put(key, UIManager.getLookAndFeelDefaults().get(key, locale));
            }
            if (locale.getLanguage().equals("de")) {
                UIManager.put("ColorChooser.swatchesNameText", "Farbfelder");
            }
        }
    }

    public static void updateComponentTreeUI(Container container) {
        JComponent.setDefaultLocale(Locale.getDefault());
        ComponentManager.updateInputComponentsFont(container);
        SwingUtilities.updateComponentTreeUI(container);
    }

    private static void updateInputComponentsFont(Container container) {
        for (JComponent jComponent : ComponentManager.getComponents(container, JComboBox.class)) {
            jComponent.setFont(UIManager.getFont("ComboBox.font"));
        }
        for (JComponent jComponent : ComponentManager.getComponents(container, JEditorPane.class)) {
            jComponent.setFont(UIManager.getFont("EditorPane.font"));
        }
        for (JComponent jComponent : ComponentManager.getComponents(container, JFormattedTextField.class)) {
            jComponent.setFont(UIManager.getFont("FormattedTextField.font"));
        }
        for (JComponent jComponent : ComponentManager.getComponents(container, JList.class)) {
            jComponent.setFont(UIManager.getFont("List.font"));
        }
        for (JComponent jComponent : ComponentManager.getComponents(container, JPasswordField.class)) {
            jComponent.setFont(UIManager.getFont("PasswordField.font"));
        }
        for (JComponent jComponent : ComponentManager.getComponents(container, JSpinner.class)) {
            jComponent.setFont(UIManager.getFont("Spinner.font"));
        }
        for (JComponent jComponent : ComponentManager.getComponents(container, JTable.class)) {
            jComponent.setFont(UIManager.getFont("Table.font"));
        }
        for (JComponent jComponent : ComponentManager.getComponents(container, JTextArea.class)) {
            jComponent.setFont(UIManager.getFont("TextArea.font"));
        }
        for (JComponent jComponent : ComponentManager.getComponents(container, JTextField.class)) {
            jComponent.setFont(UIManager.getFont("TextField.font"));
        }
        for (JComponent jComponent : ComponentManager.getComponents(container, JTextPane.class)) {
            jComponent.setFont(UIManager.getFont("TextPane.font"));
        }
    }

    private static <T extends JComponent> List<T> getComponents(Container container, Class<T> type) {
        ArrayList<JComponent> list = new ArrayList<JComponent>();
        for (Component component : container.getComponents()) {
            if (type.isInstance(component)) {
                list.add((JComponent)component);
                continue;
            }
            if (!(component instanceof Container)) continue;
            Container ctr = (Container)component;
            list.addAll(ComponentManager.getComponents(ctr, type));
        }
        return list;
    }
}

